# -*- coding: utf-8 -*-

require File.dirname(__FILE__) + '/../spec_helper.rb'

module Mint::Generator

  describe FractionalArithmetic do

    subject{ FractionalArithmetic.new }

    before(:all) { @opt_pattern = %r! [+\-*]|div ! }

    it_should_behave_like 'Arithmetic'

    it do
      subject.should_receive(:fraction)
      subject.__send__(:operand)
    end

    context 'create expression' do
      (1..100).to_a.shuffle[1, 10].each do |n|
        context n do
          before do
            settings = {
              :minus => true,
              :numerator_min   => 1, :numerator_max   => 100,
              :denominator_min => 2, :denominator_max => 100,
              :term_number => n,
            }
            @problems = subject.generate(settings)
          end
          it { @problems.should have(1).problem }
          it { @problems.first.split(@opt_pattern).should have(n).operands }
          it { @problems.first.scan(@opt_pattern).should have(n-1).operator }
          it { @problems.first.split(@opt_pattern).each {|operand| operand.should match(%r!/!) } }
        end
      end
      context 'lowest term' do
        [
          [2, 4, false],
          [8, 4, false],
          [12, 3, false],
          [0, 0, false],
          [5, 5, false],
          [5, 3, true],
          [8, 5, true],
          [12, 16, false],
          [3, 9, false],
          [9, 3, false],
          [7, 13, true],
        ].each do |numerator, denominator, expect|
          context "#{numerator}/#{denominator}" do
            it { subject.__send__(:is_lowest_term?, numerator, denominator).should == expect }
          end
        end
      end
    end

    context 'better problem' do
      before do
        generator = Mint::Generator::Factory.create(:fractional_arithmetic)
        @solver = Mint::Solver::Maxima::Factory.create(:fractional_arithmetic)
        @problem = generator.generate.first
      end

      10.times do
        context 'for problem' do
          before do
            @a, @b, @c, @d = @problem.scan(/(-?\d+)\/(-?\d+) .+ \((-?\d+)\/(-?\d+)\)/)[0]
          end
          it('front') { @a.to_i.gcd(@b.to_i).should == 1 }
          it('rear')  { @c.to_i.gcd(@d.to_i).should == 1 }
        end

        it do
          a, b = @solver.solve(Mint::Builder.build(@problem)).to_s.scan(/(-?\d+) \/ (-?\d+)/)[0]
          a.to_i.gcd(b.to_i).should >= 1
        end
      end
    end

    context 'need parenthesis' do
      %w[ * div ].each do |operator|
        context operator do
          before do
            settings = { :operators => [operator], :minus => false }
            @problems = subject.generate(settings)
          end
          it { @problems.first.split(operator)[1].should match(/\(.*\)/) }
        end
      end
    end
  end
end

