# -*- coding: utf-8 -*-

require File.dirname(__FILE__) + '/../../spec_helper.rb'

module Mint::Solver::Maxima

  describe ComplexNumberArithmetic do

    subject { ComplexNumberArithmetic.new }

    [
       ['(8 - 8 * %i) / (8 + 8 * %i)', '-%i'],
       ['(7 - 2 * %i) / (7 + 2 * %i)', '-(28*%i-45)/53'],
       ['(9 + 9 * %i) * (6 - 2 * %i)', '36*%i+72'],
       ['(8 - 2 * %i) * (6 - 9 * %i)', '30-84*%i'],

    ].each do |exp, ans|
      it exp do
        expression = Mint::Builder.build(exp)
        result = subject.solve(expression)
        answer = Mint::Builder.build(ans)
        result.should == answer
      end
    end
  end
end

