# -*- coding: utf-8 -*-

require File.dirname(__FILE__) + '/../../spec_helper.rb'

module Mint::Solver::Maxima

  describe FractionalExpressionArithmetic do

    subject { FractionalExpressionArithmetic.new }

    [
      ['(x + 2) / (x + 7) * -(x + 5) / (x + 8)', '-(x+2)(x+5)/((x+7)(x+8))'],
      ['(x + 8) / (x + 9) + (x + 2) / (x + 7)', '2(x^2+13x+37)/((x+7)(x+9))'],
      ['(x + 5) / (x + 6) + (x + 7) / (x + 1)', '(2x^2+19x+47)/((x+1)(x+6))'],
      ['(x + 2) / (x + 5) * (x + 5) / (x + 2)', '1'],
    ].each do |exp, ans|
      it exp do
        expression = Mint::Builder.build(exp)
        result = subject.solve(expression)
        answer = Mint::Builder.build(ans)
        result.should == answer
      end
    end
  end
end

