# -*- coding: utf-8 -*-

require File.dirname(__FILE__) + '/../../spec_helper.rb'

module Mint::Solver::Maxima

  describe PartialFractionExpansion do

    subject { PartialFractionExpansion.new }

    [
      ['1/(x + 1)(x + 2)', '1 / (x + 1) - 1 / (x + 2)'],
    ].each do |exp, ans|
      it exp do
        expression = Mint::Builder.build(exp)
         result = subject.solve(expression)
        answer = Mint::Builder.build(ans)
        result.should == answer
      end
    end
  end
end

