# -*- coding: utf-8 -*-

require File.dirname(__FILE__) + '/../spec_helper.rb'

module Mint

  describe Generator::Base do

    context 'set amount' do

      10.times do |i|
        context i do
          before { @amount = rand(i) + 1 }
          subject { Generator::Base.new(@amount) }
          it { subject.should have_certain_param(:@amount, @amount) }
        end
      end

      it 'sets default amount' do
        generator = Generator::Base.new
        generator.should have_certain_param(:@amount, 1)
      end
    end

    context 'generate problems' do

      subject { Generator::Base.new }

      it_should_behave_like 'generator'

      it 'when set 0' do
        generator = Generator::Base.new(0)
        generator.should_not_receive(:generate_problem)
        generator.generate.should have(0).problems
      end

      (1..100).to_a.shuffle[0, 10].each do |amount|
        context "#{amount} problem(s)" do
          before do
            subject.should_receive(:setup).
              exactly(amount).times.with(no_args)
            subject.should_receive(:generate_problem).
              exactly(amount).times.and_return('problem')
            subject.should_receive(:teardown).
              exactly(amount).times.with('problem')
          end
          subject { Generator::Base.new(amount) }
          it { subject.generate.should have(amount).problems }
        end
      end

      context 'validation' do

        subject { Generator::Base.new }
        before do
          @incorrect = '1 - 2'
          @correct = '1 + 2'
        end
        after do
          subject.class.__send__(
            :class_variable_set,
            :@@validations,
            Hash.new {|h, k| h[k] = [] })
        end

        context 'general' do

          before do
            @validations = [/test/, /add/]
            class A < Generator::Base; end
            A.__send__(:validation, @validations[0])
          end
          subject { A.new }

          it { A.__send__(:class_variable_get, :@@validations).should == {'Mint::A' => [@validations[0]]} }
          it { subject.should have_certain_param(:@validations, [@validations[0]]) }
          it 'add' do
            subject.validation_add(@validations[1])
            subject.instance_variable_get(:@validations).should include(*@validations)
          end
        end

        it 'success' do
          subject.should_receive(:generate_problem).twice.and_return(@incorrect, @correct)
          subject.class.__send__(:validation, /1 \+ 2/)
          subject.generate.should == [@correct]
        end
        it 'fail' do
          start = Time.now
          subject.should_receive(:generate_problem).any_number_of_times.and_return(@incorrect)
          subject.class.__send__(:validation, /1 \* 2/)
          expect { subject.generate }.
            to raise_error('failed to create a correct problem')
          (Time.now - start).should be_close(1, 0.5)
        end
      end
    end

    context 'need overwrite' do
      before { @message = 'you must overwrite generate_problem.' }
      subject { Generator::Base.new }
      it { expect { subject.__send__(:generate_problem) }.to raise_error(@message) }
    end
  end
end

