# -*- coding: utf-8 -*-

require File.dirname(__FILE__) + '/../spec_helper.rb'

module Mint::Generator
  describe ComplexNumberArithmetic do

    subject{ ComplexNumberArithmetic.new }

    before(:all) { @opt_pattern = %r![+\-]! }

    it_should_behave_like 'Arithmetic'

    context 'create complex number' do

      before(:all) { @defaults = { :min => 1 } }

      it 'zero' do
        settings = @defaults.merge(:min => 0, :max => 0)
        subject.__send__(:options=, settings)
        result = subject.__send__(:create_complex_number)
        result.should match(/\A[2-9]\z/)
      end

      it 'one' do
        settings = @defaults.merge(:max => 1)
        subject.__send__(:options=, settings)
        result = subject.__send__(:create_complex_number)
        result.should match(/\A\(1 [\-+] %i\)\z/)
      end

      it 'general' do
        settings = @defaults.merge(:min => 2, :max => 9)
        subject.__send__(:options=, settings)
        result = subject.__send__(:create_complex_number)
        result.should match(/\A\(\d [\-+] \d%i\)\z/)
      end

      it 'include 10' do
        subject.stub(:create_integer).and_return(2, 10)
        subject.stub(:plus_or_minus => '+')
        result = subject.__send__(:create_complex_number)
        result.should_not match(/\A\(2 \+ 0%i\)\z/)
      end

      it 'conjugate complex' do
        settings = @defaults.merge(:max => 1)
        subject.__send__(:options=, settings)
        original = subject.__send__(:create_complex_number)
        conjugate = subject.__send__(:conjugate_complex, original)
        _, original_opt, _ = *original.split
        _, conjugate_opt, _ = *conjugate.split
        invert_table = { '-' => '+', '+' => '-' }
        invert_table[conjugate_opt].should == original_opt
      end
    end

    context 'create expression' do

      context 'single term' do
        before do
          settings = { :min => 2, :max => 9, :term_number => 1 }
          @problem = subject.generate(settings)
          @expected_pattern = /\A\(\d [\-+] \d%i\)\^2\z/
        end
        it { @problem.first.should match(@expected_pattern) }
      end

      context 'multiple' do
        before do
          settings = { :min => 2, :max => 9, :operators => ['*'] }
          @problem = subject.generate(settings)
          @expected_pattern = /\A\(\d [\-+] \d%i\) \* \(\d [\-+] \d%i\)\z/
        end
        it { @problem.first.should match(@expected_pattern) }
      end

      context 'fractional' do
        before do
          settings = { :min => 2, :max => 9, :operators => ['/'] }
          @problem = subject.generate(settings)
          @expected_pattern = /\A\((\d) [\-+] (\d)%i\) \/ \(\1 [\-+] \2%i\)\z/
        end
        it { @problem.first.should match(@expected_pattern) }
      end

      context 'fractional mode' do
        before do
          settings = { :min => 2, :max => 9, :fractional_mode => true }
          @problem = subject.generate(settings)
          @expected_pattern = /\A\d \/ \(\d [\-+] \d%i\) [\-+] \d \/ \(\d [\-+] \d%i\)\z/
        end
        it { @problem.first.should match(@expected_pattern) }
      end
    end
  end
end

