# -*- coding: utf-8 -*-

require File.dirname(__FILE__) + '/../spec_helper.rb'

module Mint

  describe Generator::PartialFractionExpansion do
    subject{ Generator::PartialFractionExpansion.new }

    it_should_behave_like 'HighOrderExpression'

    context 'without numerato' do
      context 'without coefficient' do
        before do
          options = { :x => ['x', 'y', 'z'], :factor_max => 10 }
          @problems = subject.generate(options)
        end
        it{ @problems.should have(1).problem }
        it{ @problems.first.split(%r!\/!).should have(2).terms }
        it{ @problems.first.should match(%r!1\/\([xyz]\s\+\s\d+\)\([xzy]\s\+\s\d+\)!) }
      end
      context 'with coefficient' do
        before do
          options = {
            :x => ['a', 'b', 'c'],
            :coefficient_min => 2,
            :coefficient_max => 9
          }
          @problems = subject.generate(options)
        end
        it{ @problems.first.should match(%r!1\/\([2-9][abc]\s\+\s\d+\)\([2-9][abc]\s\+\s\d+\)!) }
      end
    end
    context 'with numerator' do
      context 'set min' do
        before do
          options = { :numerator_min => 2 }
          @problems = subject.generate(options)
        end
        it{ @problems.first.should match(%r![12]\/\(x\s\+\s\d+\)\(x\s\+\s\d+\)!) }
      end
      context 'set min and max' do
        (1..100).to_a.shuffle[0, 10].combination(2) do |min, max|
          context "#{min}..#{max}" do
            before do
              min, max = [min, max].sort
              options = {
                :numerator_min => min,
                :numerator_max => max,
              }
              @problems = subject.generate(options)
            end
            it{ @problems.first.should match(%r!(#{(min..max).to_a.join('|')})\/\(x\s\+\s\d+\)\(x\s\+\s\d+\)!) }
          end
        end
      end
      context 'multiple variable' do
        before do
          options = { :x => [['x', 'y']] }
          @problem = subject.generate(options).first
        end
        it { @problem.should match(%r!1\/\(x\s\+\s(?:\d+)?y\)\(x\s\+\s(?:\d+)?y\)!) }
      end
    end
  end
end

