# -*- coding: utf-8 -*-

require File.dirname(__FILE__) + '/../../spec_helper.rb'

module Mint::Generator

  describe Utilities do

    before(:all) { class Klass; include Utilities end }

    subject { Klass.new }

    context 'create integer' do
      [
        [0, 0],
        [1, 2],
        [1, 10],
        [10, 1],
        [-10, 1],
        [-10, -5],
        [100, 200000],
      ].each do |min, max|
        it "(#{min}..#{max})" do
          ans = subject.create_integer(min, max, false)
          range = Range.new(*[min, max].map {|i| i < 0 ? -i : i }.sort)
          range.should include(ans)
        end
        it "(#{min}..#{max}) (minus)" do
          ans = subject.create_integer(min, max, true)
          _max = [min, max].map {|i| i < 0 ? -i : i }.max
          (-_max.._max).should include(ans)
        end
      end

      context 'with block' do
        before { subject.should_receive(:rand).at_least(3).times.and_return(1, 2, 3) }
        it { subject.create_integer(1, 2, true) {|i| i > 3 } }
      end
    end

    context 'sign' do
      before { subject.stub(:rand => 1) }
      it { subject.sign(true).should == -1 }
      it { subject.sign(false).should == 1 }
    end

    context 'factor' do
      %w[
        test spec mint 0 -95
      ].each do |target|
        it do
          options = {:"#{target}_min" => 1, :"#{target}_max" => 10, :"#{target}_minus" => false}
          (1..10).should include(subject.factor(options, target))
        end
      end
    end

    context 'single' do
      context '1 variable' do
        ['x', 'y'].each do |x|
          [
            [ 1,  2, x, "(#{x} + 2)"],
            [ 0,  2, x, '2'],
            [-1,  2, x, "(-#{x} + 2)"],
            [ 1, -2, x, "(#{x} - 2)"],
            [ 2,  2, x, "(2#{x} + 2)"],
            [-2,  2, x, "(-2#{x} + 2)"],
            [ 2, -2, x, "(2#{x} - 2)"],
            [ 0, -2, x, '-2'],
            [ 1,  0, x, "#{x}"],
          ].each do |a, b, x, ptn|
            it(ptn) { subject.single(a, b, x).should == ptn }
          end
        end
      end
      context '2 variable' do
        [['x', 'y'], ['a', 'b']].each do |x, y|
          [
            [ 1,  2, x, y, "(#{x} + 2#{y})"],
            [-1,  2, x, y, "(-#{x} + 2#{y})"],
            [ 1, -2, x, y, "(#{x} - 2#{y})"],
            [ 2,  2, x, y, "(2#{x} + 2#{y})"],
            [-2,  2, x, y, "(-2#{x} + 2#{y})"],
            [ 2, -2, x, y, "(2#{x} - 2#{y})"],
          ].each do |a, b, x, y, ptn|
            it(ptn) { subject.single(a, b, [x, y]).should == ptn }
          end
        end
      end
    end

    context 'min_max_order' do
      it do
        options = { :hoge_min => 1, :hoge_max => 2 }
        subject.min_max_order(options, 'hoge').
          values_at(:hoge_min, :hoge_max).should == [1, 2]
      end
      it do
        options = { :hoge_min => 2, :hoge_max => 1 }
        subject.min_max_order(options, 'hoge').
          values_at(:hoge_min, :hoge_max).should == [2, 2]
      end
    end

    context 'sample' do
      subject { [1, 2, 3, 4, 5] }
      it do
        subject.should_receive(:choice)
        subject.sample
      end
      it do
        n = 5
        subject.should_receive(:shuffle).and_return(subject)
        subject.should_receive(:slice).with(0..(n-1))
        subject.sample(n)
      end
    end

    context 'factorize' do

      [
        [5, [[5, 1]]],
        [9, [[3, 2]]],
        [15, [[3, 1], [5, 1]]],
        [24, [[2, 3], [3, 1]]],
        [100, [[2, 2], [5, 2]]],
        [1000, [[2, 3], [5, 3]]],
      ].each do |n, expected|
        it { n.should respond_to(:factorize) }
        it { n.factorize.should == expected }
      end
      it { lambda { 0.factorize }.should raise_error(ZeroDivisionError) }
    end
  end
end

