# -*- coding: utf-8 -*-

require File.dirname(__FILE__) + '/../spec_helper.rb'

module Mint::Solver

  describe Base do

    subject { Base.new }

    context 'solve problem' do
      before { @expression = Mint::Builder.build('5+ 4') }
      it do
        answer = :answer
        Mint::Builder.should_receive(:build).with(@expression.to_maxima).and_return(answer)
        subject.should_receive(:solve_problem).and_return(@expression.to_maxima)
        subject.solve(@expression).should == answer
      end
      it { expect { subject.solve(Mint::NullExpression.new) }.to raise_error(NullExpressionError) }
    end

    context 'must overwrite' do
      before { @exception = [RuntimeError, 'you must overwrite this method.'] }
      it { expect { subject.__send__(:solve_problem, nil) }.to raise_error(*@exception) }
    end
  end
end

