# -*- coding: utf-8 -*-

require File.dirname(__FILE__) + '/../../spec_helper.rb'

module Mint::Solver::Maxima

  describe Base do

    subject { Base.new }

    it 'uses maxima' do
      answer = subject.__send__(:maxima, '2 + 3')
      answer.should == '5'
    end

    context 'exec' do
      before { @expression = '5 + 2' }
      it 'good' do
        answer = Mint::Solver::Maxima.exec_maxima(@expression)
        answer.should match(/\(\%o3\) 7/)
      end

      it 'bad' do
        problem = @expression[0, 3]
        expect {
          answer = Mint::Solver::Maxima.exec_maxima(problem)
        }.to raise_error("maxima can't solve this problem: #{problem}")
      end
    end

    context 'expansion' do
      before do
        @expression = Mint::Builder.build('(x^2 + 1)(x^3 - 5)')
        subject.should_receive(:query).
          with("expand(#{@expression.to_maxima})")
      end

      it { answer = subject.__send__(:expand, @expression.to_maxima) }
    end

    context 'factorization' do
      before do
        @expression = Mint::Builder.build('(x^2 + 3x + 1)')
        subject.should_receive(:query).
          with("factor(#{@expression.to_maxima})")
      end

      it { answer = subject.__send__(:factor, @expression.to_maxima) }
    end

    context 'rectform' do
      before do
        @expression = Mint::Builder.build('(5 + %i) / (5 + %i)')
        subject.should_receive(:query).
          with("rectform(#{@expression.to_maxima})")
      end

      it { answer = subject.__send__(:rectform, @expression.to_maxima) }
    end

    context 'ratsimp' do
      before do
        @expression = Mint::Builder.build('(5 + %i) / (5 + %i)')
        subject.should_receive(:query).
          with("ratsimp(#{@expression.to_maxima})")
      end

      it { answer = subject.__send__(:ratsimp, @expression.to_maxima) }
    end

    context 'partial fraction' do
      context 'valid' do
        before do
          @expression = Mint::Builder.build('1 / (x + 1)*(x + 2)')
          subject.should_receive(:query).
            with("partfrac(#{@expression.to_maxima}, x)")
        end
        it { answer = subject.__send__(:partfrac, @expression.to_maxima) }
      end
      context 'invalid' do
        before do
          @expression = Mint::Builder.build('1 / 1 * 2')
        end
        it {
          expect {
            subject.__send__(:partfrac, @expression.to_maxima)
          }.to raise_error('invalid fractional expression')
        }
      end
    end
  end
end
