# -*- coding: utf-8 -*-

require File.dirname(__FILE__) + '/../../spec_helper.rb'

module Mint::Solver::Maxima

  describe DecimalArithmetic do

    subject { DecimalArithmetic.new }

    [
      ['0.18 * (-0.44)',   '-0.0792'],
      ['-0.25 + (-0.15)',   '-0.4'],
    ].each do |exp, ans|
      it exp do
        expression = Mint::Builder.build(exp)
        result = subject.solve(expression)
        answer = Mint::Builder.build(ans)
        result.should == answer
      end
    end
  end
end

