# -*- coding: utf-8 -*-

require File.dirname(__FILE__) + '/../../spec_helper.rb'

module Mint::Solver::Maxima

  describe Factorization do

    subject { Factorization.new }
    [
      ['6a^2 - a - 2', '(2a + 1)(3a - 2)'],
      ['6a^2 - ab - 2b^2', '(2a + b)(3a - 2b)'],
      ['6a^2 - ab - 2b^2', '(2a + b)(3a - 2b)'],
      ['x^3 + 6x^2 - 51x + 44', '(x-4)(x-1)(x+11)'],
      ['x^3 + 6x^2y - 51xy^2 + 44y^3', '(x-4y)(x-1y)(x+11y)'],
    ].each do |exp, ans|
      it exp do
        expression = Mint::Builder.build(exp)
        result = subject.solve(expression)
        answer = Mint::Builder.build(ans)
        result.should == answer
      end
    end
  end
end

