# -*- coding: utf-8 -*-

require File.dirname(__FILE__) + '/../../spec_helper.rb'

module Mint::Solver::Maxima

  describe QuadraticEquation do

    subject { QuadraticEquation.new }
    [

      ['49 x^2 - 28 x - 96',   ['12/7',' -8/7']],
      ['8 x^2 - 2 x - 3',      ['3/4', '-1/2']],
      ['x^2  - 20 x + 51',     ['17', '3']],
      ['64 x^2 + 16 x - 5',    ['-1/8 + root(6)/8', '-1/8 - root(6)/8']],
      ['50 x^2 - 40 x - 1',    ['2/5 + 3 root(2)/10', '2/5 - 3 root(2)/10']],
      ['18 x^2 + 15 x - 1',    ['-5/12 +  root(33)/12', '-5/12 -  root(33)/12']],
      ['225 x^2 - 120 x + 31', ['4/15+root(15)i/15', '4/15-root(15)i/15']],
      ['x^2  + 7 x + 16',      ['-7/2+root(15)i/2', '-7/2-root(15)i/2']],
      ['49 x^2 - 84 x + 64',   ['6/7+2root(7)i/7', '6/7-2root(7)i/7']],
      ['(x + 2)^2', ['-2']],

    ].each do |exp, ans|
      it exp do
        expression = Mint::Builder.build(exp)
        result = subject.solve(expression)
        answers = ans.map {|a| Mint::Builder.build(a) }
        result.each do |ans|
          eq = answers.any? {|a| a == ans }
          eq.should be_true
        end
      end
    end
  end
end

