# -*- coding: utf-8 -*-

require File.dirname(__FILE__) + '/../../spec_helper.rb'

module Mint::Solver::Simple

  describe LinearFunctionGraph do
    before do
      @klass = LinearFunctionGraph
      @solver = @klass.new
    end

    [
     [{ :gradient => 1, :intercept => 1 }, "x + 1"],
     [{ :gradient => 2, :intercept => 1 }, "2x + 1"],
     [{ :gradient => 2, :intercept => -1 }, "2x - 1"],
     [{ :gradient => 2, :intercept => 0 }, "2x"],
     [{ :gradient => -2, :intercept => 0 }, "-2x"],
     [{ :gradient => 1, :intercept => 0 }, "x"],
     [{ :gradient => -1, :intercept => 0 }, "-x"],
     [{ :gradient => "1/2", :intercept => "1/2" }, "(1/2)x + 1/2"],
     [{ :gradient => "1/2", :intercept => "-1/2" }, "(1/2)x - 1/2"],
    ].each do |problem, expected|
      it{ @solver.solve(problem).should == Mint::Builder.build(expected) }
    end
  end

end
