#include "../hed/hed_common/stl.h"
#include "../hed/hed_picturelib/filter.h"
#include "../hed/hed_picturelib/plimage.h"
#include "../hed/hed_picturelib/pldata.h"
#include "../hed/hed_picturelib/filedata.h"
#include "../hed/hed_picturelib/plmemoryimage.h"
#include "../hed/hed_susie/decodepicture.h"
#include "../hed/hed_susie/susiepluginarray.h"

bool WINAPI cnv_read_image( const TCHAR *strFile, CPLImage &hImageResult )
{
	bool result = false;
	TCHAR path[MAX_PATH];
	TCHAR drive[_MAX_DRIVE];
	TCHAR dir[_MAX_PATH];
	
	// st@CpXȉ plugins fBNg̓vOCǂݍ
	::GetModuleFileName( NULL, path, MAX_PATH );
	_tsplitpath( path, drive, dir, NULL, NULL );
	_tcscpy( path, drive );
	_tcscat( path, dir );
	_tcscat( path, _T("plugins\\") );

	CSusiePluginArray *plugins = 
		CSusiePluginArray::GetSusiePluginArray();
	plugins->add_plugin_files( path );

	// ϊΏۃt@CɑΉ̓vOC
	CPLFileData *fileData = CPLFileData::create( strFile);
	CPLData data(strFile, fileData);
	CPluginObject *pluginObject = NULL;
	HANDLE hFindPlugin =
		plugins->find_plugin_first( &data, &pluginObject, true );

	// vOCꍇA̓t@C`̃f[^ɃRo[g
	if( hFindPlugin != NULL && 
		pluginObject != NULL )
	{
		CDecodePicture *decoder = dynamic_cast<CDecodePicture*>(pluginObject);
		if( decoder != NULL )
			result = decoder->DecodePicture( &data, &hImageResult, NULL, NULL );
	}

	// vOCnhN[Y
	plugins->find_plugin_close( hFindPlugin );

	return result;
}

/* input_plugin output_plugin input_file output_file */
int main( int argc, TCHAR**argv )
{
	if( argc != 5 )
	{
		cout << "convert.exe <import_plugin.iplg|*> export_plugin.eplg input_file_name output_file_name" << endl;
		return -1;
	}

	HINSTANCE hInstanceImageRead = NULL;
	HINSTANCE hInstanceImageWrite = NULL;
	FP_READ_IMAGE fpReadImage = NULL;
	FP_WRITE_IMAGE fpWriteImage = NULL;

	if( _tcsicmp( argv[1], _T("*") ) != 0 )
	{
		hInstanceImageRead = ::LoadLibrary( argv[1] );
		fpReadImage = 
			( FP_READ_IMAGE )::GetProcAddress( hInstanceImageRead, "read_image" );
	}
	else
	{
		fpReadImage = cnv_read_image;
	}

	hInstanceImageWrite =
		::LoadLibrary( argv[2] );
	fpWriteImage = 
		( FP_WRITE_IMAGE )::GetProcAddress( hInstanceImageWrite, "write_image" );

	if( fpReadImage == NULL ||
		fpWriteImage == NULL )
	{
		cout << "cannot load input or output plugin dll.\n";
		return -1;
	}

	CPLImage *image = new CPLMemoryImage( );
	image->CreateImage( _T("IMAGE") );
	if( fpReadImage( argv[3], *image ) )
	{
		if( !fpWriteImage( image, argv[4], NULL ) )
		{
			cout << "fail to write image file.\n";
		}
	}
	else
	{
		cout << "fail to read image file.\n";
	}
	delete image;

	return 0;
}