// FastStream.h: CFastStream NX̃C^[tFCX
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_FASTSTREAM_H__6C85EF48_8099_4048_9ABB_C85A1CE02B07__INCLUDED_)
#define AFX_FASTSTREAM_H__6C85EF48_8099_4048_9ABB_C85A1CE02B07__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#undef _EXPORT_
#ifdef PIC_KERNEL_EXPORTS
#define _EXPORT_ __declspec(dllexport) 
#else
#define _EXPORT_ __declspec(dllimport) 
#endif

#include <windows.h>

class _EXPORT_ CFastStream
{
public:

	virtual bool __fastcall open( TCHAR *strFileName, UINT eOpenMode );
	virtual bool __fastcall read( unsigned char *pBuffer, unsigned int nPosition, unsigned int nSize );
	virtual bool __fastcall direct_read( const unsigned char ** const pBuffer, unsigned int nPosition, unsigned int nSize );
	virtual bool __fastcall write( unsigned char *pBuffer, unsigned int nPosition, unsigned int nSize );
	virtual bool __fastcall flush( );
	virtual bool __fastcall close( );

	virtual void __fastcall get_file_name( TCHAR *strFileName );
	virtual bool __fastcall is_open( );

	CFastStream();
	virtual ~CFastStream();

	static const UINT OPEN_READ ;
	static const UINT OPEN_WRITE ;
	static const UINT OPEN_TRUNC;
	static const UINT OPEN_TEMP;

protected:
	void __fastcall	init( );

	BOOL			m_bTempFile;
	unsigned char	*m_pTempBuffer;
	unsigned char	*m_buffer;
	unsigned long	m_sizeofUsedBuffer;
	unsigned long	m_currentBufferStartPosition;
	HANDLE			m_hFile;
	unsigned int	m_TempBufferSize;
	UINT			m_uiMode;
	BOOL			m_bWrite;
	TCHAR			m_strFileName[MAX_PATH];
	unsigned int	_BUFFER_SIZE_;
};

#endif // !defined(AFX_FASTSTREAM_H__6C85EF48_8099_4048_9ABB_C85A1CE02B07__INCLUDED_)
