#include "../hed/hed_common/stl.h"
#include <windows.h>
#include <stdio.h>

#include "cdjpeg.h"		/* Common decls for cjpeg/djpeg applications */
#include "jversion.h"		/* for version message */

/* Create the add-on message string table. */

#define JMESSAGE(code,string)	string ,

static const char * const cdjpeg_message_table[] = {
#include "cderror.h"
  NULL
};

#include "../hed/hed_picturelib/plimage.h"
#include "../hed/hed_picturelib/pldata.h"
#include "../hed/hed_picturelib/memorydata.h"
#include "../hed/hed_picturelib/filedata.h"


typedef struct {
  struct djpeg_dest_struct pub;	/* public fields */
  int current_row;
} plimage_dest_struct;

typedef plimage_dest_struct * plimage_dest_ptr;
typedef plimage_dest_struct bmp_memory_dest_struct;
typedef bmp_memory_dest_struct * bmp_memory_dest_ptr;

METHODDEF(void)
start_output_plimage (j_decompress_ptr cinfo, djpeg_dest_ptr dinfo)
{
  plimage_dest_ptr dest = (plimage_dest_ptr) dinfo;
	CPLImage *plImage = 
		(CPLImage*)dest->pub.output_file;
	plImage->CreateImage( _T("IMAGE"), cinfo->output_width, cinfo->output_height, 24 );
	dest->current_row = 0;
}

METHODDEF(void)
finish_output_plimage (j_decompress_ptr cinfo, djpeg_dest_ptr dinfo)
{
}

METHODDEF(void)
put_pixel_rows (j_decompress_ptr cinfo, djpeg_dest_ptr dinfo,
		 JDIMENSION rows_supplied)
{
  plimage_dest_ptr dest = (plimage_dest_ptr) dinfo;
	CPLImage *plImage = 
		(CPLImage*)dest->pub.output_file;
  register JSAMPROW ptr;
  ptr = dest->pub.buffer[0];

  COLORREF *cr = (COLORREF*)malloc( sizeof(COLORREF) * cinfo->image_width );
  for( unsigned int col = 0; col < cinfo->image_width; col ++ )
  {
	  cr[col] = RGB( *(ptr), *(ptr+1), *(ptr+2) );
	  ptr += 3;
  }
  plImage->SetImageLine( dest->current_row, (unsigned char*)cr );
  free( cr );
  dest->current_row ++;
}

METHODDEF(void)
put_gray_rows (j_decompress_ptr cinfo, djpeg_dest_ptr dinfo,
	       JDIMENSION rows_supplied)
/* This version is for grayscale OR quantized color output */
{
  plimage_dest_ptr dest = (plimage_dest_ptr) dinfo;
	CPLImage *plImage = 
		(CPLImage*)dest->pub.output_file;
  register JSAMPROW ptr;
  ptr = dest->pub.buffer[0];
  COLORREF *cr = (COLORREF*)malloc( sizeof(COLORREF) * cinfo->image_width );
  for( unsigned int col = 0; col < cinfo->image_width; col ++ )
  {
	  cr[col] = RGB( *ptr, *ptr, *ptr );
	  ptr ++;
  }
  plImage->SetImageLine( dest->current_row, (unsigned char*)cr );
  free( cr );
  dest->current_row ++;
}

METHODDEF(djpeg_dest_ptr)
jinit_write_pl_image (j_decompress_ptr cinfo)
{
  /* Create module interface object, fill in method pointers */
  plimage_dest_ptr dest = (plimage_dest_ptr)
      (*cinfo->mem->alloc_small) ((j_common_ptr) cinfo, JPOOL_IMAGE,
				  SIZEOF(plimage_dest_struct));
  dest->pub.start_output = start_output_plimage;
  dest->pub.finish_output = finish_output_plimage;

  /* Calculate output image dimensions so we can allocate space */
  jpeg_calc_output_dimensions(cinfo);

  if (cinfo->out_color_space == JCS_GRAYSCALE) {
    dest->pub.put_pixel_rows = put_gray_rows;
  } else if (cinfo->out_color_space == JCS_RGB) {
    if (cinfo->quantize_colors)
      dest->pub.put_pixel_rows = put_gray_rows;
    else
      dest->pub.put_pixel_rows = put_pixel_rows;
  } else {
	  return NULL;
  }

  /* Create decompressor output buffer. */
  dest->pub.buffer = (*cinfo->mem->alloc_sarray)
	  ((j_common_ptr) cinfo, JPOOL_IMAGE, cinfo->output_width * cinfo->output_components, (JDIMENSION) 1);
  dest->pub.buffer_height = 1;
  return (djpeg_dest_ptr) dest;
}

METHODDEF(void)
start_output_bmp_memory (j_decompress_ptr cinfo, djpeg_dest_ptr dinfo)
{
	bmp_memory_dest_ptr dest = (bmp_memory_dest_ptr) dinfo;
	int sizeOfImage = 
		sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER) + ( ( cinfo->image_width * 3 + 3 ) & ~3 ) * cinfo->image_height;

	dest->pub.output_file = (FILE*)malloc( sizeOfImage );
	memset( dest->pub.output_file, 0x00, sizeOfImage );

	BITMAPFILEHEADER *bmfh = 
		(BITMAPFILEHEADER *)dest->pub.output_file;

	memcpy( &bmfh->bfType, "BM", 2 );
	bmfh->bfSize = sizeOfImage;
	bmfh->bfReserved1 = 0;
	bmfh->bfReserved2 = 0;
	bmfh->bfOffBits = sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER);
	dest->current_row = 0;

	BITMAPINFOHEADER *bmih = 
		(BITMAPINFOHEADER*)((LPBYTE)dest->pub.output_file + sizeof(BITMAPFILEHEADER) );
	bmih->biSize = sizeof(BITMAPINFOHEADER);
	bmih->biWidth = cinfo->image_width;
	bmih->biHeight = cinfo->image_height;
	bmih->biPlanes = 1;
	bmih->biBitCount = 24;
	bmih->biCompression = BI_RGB;
	bmih->biSizeImage = ( ( cinfo->image_width * 3 + 3 ) & ~3 ) * cinfo->image_height;
	bmih->biXPelsPerMeter = 3780;
	bmih->biYPelsPerMeter = 3780;
	bmih->biClrUsed = 0;
	bmih->biClrImportant = 0;
}

METHODDEF(void)
finish_output_bmp_memory (j_decompress_ptr cinfo, djpeg_dest_ptr dinfo)
{
}

METHODDEF(void)
put_pixel_rows_bmp_memory (j_decompress_ptr cinfo, djpeg_dest_ptr dinfo,
		 JDIMENSION rows_supplied)
{
	bmp_memory_dest_ptr dest = (bmp_memory_dest_ptr) dinfo;

	JSAMPROW ptr = dest->pub.buffer[0];
	void *target = 
		(LPBYTE)dest->pub.output_file + sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER) + ( ( cinfo->image_width * 3 + 3 ) & ~3 ) * ( cinfo->image_width - dest->current_row );
	memcpy( target, ptr, cinfo->image_width * 3 );
	dest->current_row ++;
}

METHODDEF(void)
put_gray_rows_bmp_memory (j_decompress_ptr cinfo, djpeg_dest_ptr dinfo,
	       JDIMENSION rows_supplied)
/* This version is for grayscale OR quantized color output */
{
	plimage_dest_ptr dest = (plimage_dest_ptr) dinfo;
	register JSAMPROW ptr = dest->pub.buffer[0];
	LPBYTE target = 
		(LPBYTE)dest->pub.output_file + sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER) + ( ( cinfo->image_width * 3 + 3 ) & ~3 ) * ( cinfo->image_width - dest->current_row );
  for( unsigned int col = 0; col < cinfo->image_width; col ++ )
  {
	  *target++ = *ptr;
	  *target++ = *ptr;
	  *target++ = *ptr;
	  ptr ++;
  }
  dest->current_row ++;
}

METHODDEF(djpeg_dest_ptr)
jinit_write_bmp_memory_image(j_decompress_ptr cinfo)
{
  /* Create module interface object, fill in method pointers */
  plimage_dest_ptr dest = (plimage_dest_ptr)
      (*cinfo->mem->alloc_small) ((j_common_ptr) cinfo, JPOOL_IMAGE,
	  SIZEOF(bmp_memory_dest_struct));
  dest->pub.start_output = start_output_bmp_memory;
  dest->pub.finish_output = finish_output_bmp_memory;

  /* Calculate output image dimensions so we can allocate space */
  jpeg_calc_output_dimensions(cinfo);

  if (cinfo->out_color_space == JCS_GRAYSCALE) {
    dest->pub.put_pixel_rows = put_gray_rows_bmp_memory;
  } else if (cinfo->out_color_space == JCS_RGB) {
    if (cinfo->quantize_colors)
      dest->pub.put_pixel_rows = put_gray_rows_bmp_memory;
    else
      dest->pub.put_pixel_rows = put_pixel_rows_bmp_memory;
  } else {
	  return NULL;
  }

  /* Create decompressor output buffer. */
  dest->pub.buffer = (*cinfo->mem->alloc_sarray)
	  ((j_common_ptr) cinfo, JPOOL_IMAGE, cinfo->output_width * cinfo->output_components, (JDIMENSION) 1);
  dest->pub.buffer_height = 1;
  return (djpeg_dest_ptr) dest;
}

METHODDEF(unsigned int)
jpeg_getc (j_decompress_ptr cinfo)
/* Read next byte */
{
  struct jpeg_source_mgr * datasrc = cinfo->src;

  if (datasrc->bytes_in_buffer == 0) {
    if (! (*datasrc->fill_input_buffer) (cinfo))
      ERREXIT(cinfo, JERR_CANT_SUSPEND);
  }
  datasrc->bytes_in_buffer--;
  return GETJOCTET(*datasrc->next_input_byte++);
}


METHODDEF(boolean)
print_text_marker (j_decompress_ptr cinfo)
{
  boolean traceit = (cinfo->err->trace_level >= 1);
  INT32 length;
  unsigned int ch;
  unsigned int lastch = 0;

  length = jpeg_getc(cinfo) << 8;
  length += jpeg_getc(cinfo);
  length -= 2;			/* discount the length word itself */

  if (traceit) {
    if (cinfo->unread_marker == JPEG_COM)
      fprintf(stderr, "Comment, length %ld:\n", (long) length);
    else			/* assume it is an APPn otherwise */
      fprintf(stderr, "APP%d, length %ld:\n",
	      cinfo->unread_marker - JPEG_APP0, (long) length);
  }

  while (--length >= 0) {
    ch = jpeg_getc(cinfo);
    if (traceit) {
      /* Emit the character in a readable form.
       * Nonprintables are converted to \nnn form,
       * while \ is converted to \\.
       * Newlines in CR, CR/LF, or LF form will be printed as one newline.
       */
      if (ch == '\r') {
	fprintf(stderr, "\n");
      } else if (ch == '\n') {
	if (lastch != '\r')
	  fprintf(stderr, "\n");
      } else if (ch == '\\') {
	fprintf(stderr, "\\\\");
      } else if (isprint(ch)) {
	putc(ch, stderr);
      } else {
	fprintf(stderr, "\\%03o", ch);
      }
      lastch = ch;
    }
  }

  if (traceit)
    fprintf(stderr, "\n");

  return TRUE;
}

bool __stdcall read_image( const TCHAR *strFile, CPLImage &hImageResult )
{
	struct jpeg_decompress_struct cinfo;
	struct jpeg_error_mgr jerr;
	djpeg_dest_ptr dest_mgr = NULL;
	FILE * input_file = NULL;
	JDIMENSION num_scanlines = 0;

	cinfo.err = jpeg_std_error(&jerr);
	jpeg_create_decompress(&cinfo);

	jerr.addon_message_table = cdjpeg_message_table;
	jerr.first_addon_message = JMSG_FIRSTADDONCODE;
	jerr.last_addon_message = JMSG_LASTADDONCODE;

	jpeg_set_marker_processor(&cinfo, JPEG_COM, print_text_marker);
	jpeg_set_marker_processor(&cinfo, JPEG_APP0+12, print_text_marker);

	if ((input_file = _tfopen(strFile, READ_BINARY)) == NULL)
		return false;

	jpeg_stdio_src(&cinfo, input_file);

	/* Read file header, set default decompression parameters */
	(void) jpeg_read_header(&cinfo, TRUE);

	dest_mgr = jinit_write_pl_image(&cinfo);
	if( dest_mgr != NULL )
	{
		dest_mgr->output_file = (FILE*)&hImageResult;

		/* Start decompressor */
		(void) jpeg_start_decompress(&cinfo);

		/* Write output file header */
		(*dest_mgr->start_output) (&cinfo, dest_mgr);

		/* Process data */
		while (cinfo.output_scanline < cinfo.output_height) 
		{
			num_scanlines = jpeg_read_scanlines(&cinfo, dest_mgr->buffer,
						dest_mgr->buffer_height);
			(*dest_mgr->put_pixel_rows) (&cinfo, dest_mgr, num_scanlines);
		}

		/* Finish decompression and release memory.
		* I must do it in this order because output module has allocated memory
		* of lifespan JPOOL_IMAGE; it needs to finish before releasing memory.
		*/
		(*dest_mgr->finish_output) (&cinfo, dest_mgr);
	}

	(void) jpeg_finish_decompress(&cinfo);
	jpeg_destroy_decompress(&cinfo);

	fclose(input_file);

	return dest_mgr != NULL;			/* suppress no-return-value warnings */
}

bool __stdcall get_bmp_data( const TCHAR *strFile, CPLMemoryData &pBitmap )
{
	struct jpeg_decompress_struct cinfo;
	struct jpeg_error_mgr jerr;
	djpeg_dest_ptr dest_mgr = NULL;
	FILE * input_file = NULL;
	JDIMENSION num_scanlines = 0;

	cinfo.err = jpeg_std_error(&jerr);
	jpeg_create_decompress(&cinfo);

	jerr.addon_message_table = cdjpeg_message_table;
	jerr.first_addon_message = JMSG_FIRSTADDONCODE;
	jerr.last_addon_message = JMSG_LASTADDONCODE;

	jpeg_set_marker_processor(&cinfo, JPEG_COM, print_text_marker);
	jpeg_set_marker_processor(&cinfo, JPEG_APP0+12, print_text_marker);

	if ((input_file = _tfopen(strFile, READ_BINARY)) == NULL)
		return false;

	jpeg_stdio_src(&cinfo, input_file);

	/* Read file header, set default decompression parameters */
	(void) jpeg_read_header(&cinfo, TRUE);

	dest_mgr = jinit_write_bmp_memory_image(&cinfo);
	if( dest_mgr != NULL )
	{
		dest_mgr->output_file = NULL;

		/* Start decompressor */
		(void) jpeg_start_decompress(&cinfo);

		/* Write output file header */
		(*dest_mgr->start_output) (&cinfo, dest_mgr);

		/* Process data */
		while (cinfo.output_scanline < cinfo.output_height) 
		{
			num_scanlines = jpeg_read_scanlines(&cinfo, dest_mgr->buffer,
						dest_mgr->buffer_height);
			(*dest_mgr->put_pixel_rows) (&cinfo, dest_mgr, num_scanlines);
		}

		/* Finish decompression and release memory.
		* I must do it in this order because output module has allocated memory
		* of lifespan JPOOL_IMAGE; it needs to finish before releasing memory.
		*/
		(*dest_mgr->finish_output) (&cinfo, dest_mgr);
	}

	(void) jpeg_finish_decompress(&cinfo);
	jpeg_destroy_decompress(&cinfo);

	fclose(input_file);
	if( dest_mgr != NULL )
		pBitmap.attach( dest_mgr->output_file, CPLMemoryData::MEMORY_TYPE::E_DATA_MEMORY_PL );
	return dest_mgr != NULL;			/* suppress no-return-value warnings */
}

bool __stdcall is_supported_image( CPLData *pData )
{
	return true;
}

bool __stdcall get_image_info( CPLData *pData, int &width, int &height, int &colordepth )
{
	return false;
}

bool __stdcall attach_memory_image( const void *pHeader, const void *pBits, CPLImage &hImageResult )
{
	return false;
}