#include "../hed/hed_common/stl.h"
#include <windows.h>
#include <tchar.h>
#include <stdio.h>
#include "../hed/hed_picturelib/filter.h"
#include "plg_filter.h"

extern HINSTANCE g_hInstance ;

__declspec(dllexport) bool __stdcall GetPluginInfo ( PLUGIN_INFO *pInfo )
{
	if( !pInfo )
		return false;
	pInfo->nVersionMejor = 1;
	pInfo->nVersionMinor = 0;
	_tcscpy( pInfo->chPluginName, _T("Picture Alphablend") );
	_tcscpy( pInfo->chPluginCopyright, _T("Hiroyuki Mizuhara") );

	pInfo->bSupport8_8 = true;
	pInfo->bSupport8_24 = true;
	pInfo->bSupport24_8 = false;
	pInfo->bSupport24_24 = true;
	return true;
}

__declspec(dllexport) int __stdcall GetOptionSize( )
{
	return sizeof( alphablend_picture_option );
}

__declspec(dllexport) bool __stdcall GetDefaultOption( void *pDefaultOption )
{
	if( !pDefaultOption )
		return false;
	alphablend_picture_option *pOption = ( alphablend_picture_option* )pDefaultOption;
	pOption->backColor = RGB( 0, 0, 0 );
	pOption->constantAlpha = 256;
	return true;
}

// this method is not supported yet.
__declspec(dllexport) bool __stdcall Configure( HWND hWndParent, LPVOID pOption )
{
	return false;
}
