#include "../hed/hed_common/stl.h"
#include <windows.h>
#include <tchar.h>
#include <stdio.h>
#include "../hed/hed_picturelib/filter.h"
#include "plg_filter.h"
#include "resource.h"

extern HINSTANCE g_hInstance ;

__declspec(dllexport) bool __stdcall GetPluginInfo ( PLUGIN_INFO *pInfo )
{
	if( !pInfo )
		return false;
	pInfo->nVersionMejor = 1;
	pInfo->nVersionMinor = 0;
	_tcscpy( pInfo->chPluginName, _T("Picture Resize") );
	_tcscpy( pInfo->chPluginCopyright, _T("Hiroyuki Mizuhara") );

	pInfo->bSupport8_8 = true;
	pInfo->bSupport8_24 = true;
	pInfo->bSupport24_8 = false;
	pInfo->bSupport24_24 = true;
	return true;
}

__declspec(dllexport) int __stdcall GetOptionSize( )
{
	return sizeof( resize_picture_option );
}

__declspec(dllexport) bool __stdcall GetDefaultOption( void *pDefaultOption )
{
	if( !pDefaultOption )
		return false;
	resize_picture_option *pOption = ( resize_picture_option* )pDefaultOption;
	pOption->new_size = 250;
	pOption->type = E_PERCENT;
	pOption->value = 1;
	return true;
}

BOOL CALLBACK ConfigurationDlgFunction( HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam );
__declspec(dllexport) bool __stdcall Configure( HWND hWndParent, LPVOID pOption )
{
	if( ::DialogBoxParam( g_hInstance, MAKEINTRESOURCE(IDD_CONFIGURE), hWndParent, ConfigurationDlgFunction, (LPARAM)pOption ) == IDOK )
	{
		return true;
	}
	else
	{
		return false;
	}
}

BOOL ConfigureDialogControl( HWND hWnd, WORD nControlID, WORD nAction, LPARAM lParam )
{
	switch( nControlID )
	{
	case IDC_RADIO_LOWQ:
		break;
	case IDC_RADIO_HIGHQ:
		break;
	case IDC_RADIO_PERCENT:
		if( nAction == BN_CLICKED )
		{
			HWND hWndItem = NULL;
			hWndItem = GetDlgItem( hWnd, IDC_EDIT_PERCENT );
			if( hWndItem ) EnableWindow( hWndItem, TRUE );
			hWndItem = GetDlgItem( hWnd, IDC_EDIT_HORZ );
			if( hWndItem ) EnableWindow( hWndItem, FALSE );
			hWndItem = GetDlgItem( hWnd, IDC_EDIT_VERT );
			if( hWndItem ) EnableWindow( hWndItem, FALSE );
		}
		break;
	case IDC_RADIO_SIZE:
		if( nAction == BN_CLICKED )
		{
			HWND hWndItem = NULL;
			hWndItem = GetDlgItem( hWnd, IDC_EDIT_PERCENT );
			if( hWndItem ) EnableWindow( hWndItem, FALSE );
			hWndItem = GetDlgItem( hWnd, IDC_EDIT_HORZ );
			if( hWndItem ) EnableWindow( hWndItem, TRUE );
			hWndItem = GetDlgItem( hWnd, IDC_EDIT_VERT );
			if( hWndItem ) EnableWindow( hWndItem, TRUE );
		}
		break;
	default:
		return FALSE;
	}
	return TRUE;
}

BOOL SaveValue( HWND hWnd, resize_picture_option *pOption )
{
	BOOL bLowQ = IsDlgButtonChecked( hWnd, IDC_RADIO_LOWQ );
	BOOL bHighQ = IsDlgButtonChecked( hWnd, IDC_RADIO_HIGHQ );
	BOOL bPercent = IsDlgButtonChecked( hWnd, IDC_RADIO_PERCENT );
	BOOL bSize = IsDlgButtonChecked( hWnd, IDC_RADIO_SIZE );
	TCHAR *chPercent = new TCHAR [ 256 ];
	TCHAR *chHorz = new TCHAR [ 256 ];
	TCHAR *chVert = new TCHAR [ 256 ];
	GetDlgItemText( hWnd, IDC_EDIT_PERCENT, chPercent, 255 );
	GetDlgItemText( hWnd, IDC_EDIT_HORZ, chHorz, 255 );
	GetDlgItemText( hWnd, IDC_EDIT_VERT, chVert, 255 );
	BOOL bResult = FALSE;
	if( bPercent )
	{
		int nPercent = _wtoi( chPercent );
		if( nPercent > 0 )
		{
			pOption->new_size = nPercent;
			pOption->type = E_PERCENT;
			pOption->value = ( bLowQ ) ? 0 : 1;
			bResult = TRUE;
		}
	}
	else if( bSize )
	{
		int nHorz = _wtoi( chHorz );
		int nVert = _wtoi( chVert );
		if( nHorz > 0 && nVert > 0 )
		{
			pOption->new_size = MAKELONG( nHorz, nVert );
			pOption->type = E_NEWSIZE_PIXEL;
			pOption->value = ( bLowQ ) ? 0 : 1;
			bResult = TRUE;
		}
	}
	delete [] chPercent;
	delete [] chHorz;
	delete [] chVert;
	return bResult;
}

BOOL CALLBACK ConfigurationDlgFunction( HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam )
{
	static resize_picture_option *pOption = NULL;
	switch( message )
	{
	case WM_INITDIALOG:
		pOption = ( resize_picture_option*)lParam;
		if( pOption->value == 0 )
			CheckRadioButton( hWnd, IDC_RADIO_LOWQ, IDC_RADIO_HIGHQ, IDC_RADIO_LOWQ );
		else
			CheckRadioButton( hWnd, IDC_RADIO_LOWQ, IDC_RADIO_HIGHQ, IDC_RADIO_HIGHQ );
		if( pOption->type == E_PERCENT )
		{
			TCHAR chPercent[32];
			_stprintf( chPercent, _T("%d"), pOption->new_size );
			CheckRadioButton( hWnd, IDC_RADIO_PERCENT, IDC_RADIO_SIZE, IDC_RADIO_PERCENT );
			SetDlgItemText( hWnd, IDC_EDIT_PERCENT, chPercent );
		}
		else
		{
			TCHAR chHorz[32];
			TCHAR chVert[32];
			_stprintf( chHorz, _T("%d"), LOWORD( pOption->new_size ) );
			_stprintf( chVert, _T("%d"), HIWORD( pOption->new_size ) );
			CheckRadioButton( hWnd, IDC_RADIO_PERCENT, IDC_RADIO_SIZE, IDC_RADIO_PERCENT );
			SetDlgItemText( hWnd, IDC_EDIT_HORZ, chHorz );
			SetDlgItemText( hWnd, IDC_EDIT_VERT, chVert );
		}
		PostMessage( hWnd, WM_COMMAND, MAKELONG( IDC_RADIO_HIGHQ, BN_CLICKED ), 0 );
		PostMessage( hWnd, WM_COMMAND, MAKELONG( IDC_RADIO_PERCENT, BN_CLICKED ), 0 );
		break;
	case WM_COMMAND:
		switch( LOWORD(wParam) )
		{
		case IDOK:
			if( SaveValue( hWnd, pOption ) )
			{
				EndDialog( hWnd, IDOK );
			}
			break;
		case IDCANCEL:
			EndDialog( hWnd, IDCANCEL );
			break;
		default:
			return ConfigureDialogControl( hWnd, LOWORD(wParam), HIWORD(wParam), lParam );
		}
	default:
		return FALSE;
	}
	return TRUE;
}

