#pragma once

#include "pluginobject.h"

#undef _EXPORT_
#ifdef SPLG_PICTURE_EXPORTS
#define _EXPORT_ __declspec(dllexport) 
#else
#define _EXPORT_ __declspec(dllimport) 
#endif

class CPLData ;
class CPLSusieArchiveData ;
#include "plsusiearchivedata.h"

class _EXPORT_ CSusieArchive :
	public CPluginObject
{
public:
	CSusieArchive(void);
	virtual ~CSusieArchive(void);

	virtual bool GetArchiveFileInfo( CPLData *pData, CPLSusieArchiveData **pResult );

	friend bool CPLSusieArchiveData::GetAt( int nIndex, CPLData *pDataResult );

protected:
	virtual bool Initialize( const TCHAR * const strPluginName);
	virtual bool TestPlugin( );
	virtual bool DecodeFile( CPLData *pData, 
		long offset, 
		long size, 
		CPLData *pResult,
		CALLBACKPROGRESS_SUSIE callback = NULL,
		int lParam = 0 );
};
