#include "../hed/hed_common/stl.h"
#include <windows.h>
#include <stdio.h>
#include "../hed/hed_picturelib/plimage.h"
#include "plg_filter.h"

bool alphablend_picture( CPLImage *in, CPLImage *out, alphablend_picture_option *option )
{
	int rValue = GetRValue( option->backColor );
	int gValue = GetGValue( option->backColor );
	int bValue = GetBValue( option->backColor );
	BYTE rColorMap[256];
	BYTE gColorMap[256];
	BYTE bColorMap[256];
	for( int index = 0; index < 256; index ++ )
	{
		int c = 0;

		c = ( ( ( index * option->constantAlpha ) + ( rValue * ( 256 - option->constantAlpha ) ) ) + 128 ) / 256;
		if( c < 0 ) c = 0;
		else if( c > 255 ) c = 255;
		rColorMap[index] = c;

		c = ( ( ( index * option->constantAlpha ) + ( gValue * ( 256 - option->constantAlpha ) ) ) + 128 ) / 256;
		if( c < 0 ) c = 0;
		else if( c > 255 ) c = 255;
		gColorMap[index] = c;

		c = ( ( ( index * option->constantAlpha ) + ( bValue * ( 256 - option->constantAlpha ) ) ) + 128 ) / 256;
		if( c < 0 ) c = 0;
		else if( c > 255 ) c = 255;
		bColorMap[index] = c;
	}

	int width = 0, height = 0, colorDepth = 0;
	in->GetImageSize( width, height );
	in->GetImageColorDepth( colorDepth );

	out->RenewalImage( width, height, 24 );

	COLORREF *imageLine = 
		( COLORREF * )malloc( sizeof( COLORREF ) * width );
	for( int cy = 0; cy < height; cy ++ )
	{
		in->GetImageLine( cy, (unsigned char**)&imageLine, FALSE );
		for( int cx = 0; cx < width; cx ++ )
			imageLine[cx] = 
				RGB( rColorMap[GetRValue(imageLine[cx])], gColorMap[GetGValue(imageLine[cx])], bColorMap[GetBValue(imageLine[cx])] );
		out->SetImageLine( cy, (unsigned char*)imageLine );
	}
	free( imageLine );

	return true;
}

// ėptB^ckk֐
__declspec(dllexport) bool __stdcall do_filter( CPLImage *in, CPLImage *out, void *pOption )
{
	if( !in || !out || !pOption )
		return NULL;

	alphablend_picture_option *pResizeOption = ( alphablend_picture_option *)pOption;
	return alphablend_picture( in, out, (alphablend_picture_option*)pOption );
}