#include "stdafx.h"
#include "resource.h"

#include <Exdisp.h>
#include <Mshtml.h>
#include <Shlguid.h>
#include <shlobj.h>

#include "../lib/TemplateEvaluater.h"
#include "../lib/ScriptObject.h"
#include "../lib/Configuration.h"

#include "FileCreator.h"
#include "SettingDlg.h"
#include "Setting.h"
#include "HTMLElementFilter.h"
#include "StreamWriter.h"
#include "HTMLLinkCollector.h"
#include "TemplateConfig.h"

/**
 * IẼc[j[ɓo^GNXeV̎łB
 * IÉAWXg񂩂ACOM𐶐
 * IOleCommandTargetC^[tFCXʂČĂяos܂B
 *
 * WXgɂ́ACOMIuWFNg̓o^ƁACOM
 * IEGNXeVƂēo^邽߂̃XNvg\[XuIDR_IEEXTENTIONv
 * LqĂ܂B
 * 
 * [MSDN Library: Adding Menu Items]
 * http://msdn.microsoft.com/library/default.asp?url=/workshop/browser/ext/tutorials/menu.asp
 */
class __declspec(uuid("{F58992D2-6DD8-4055-80A7-764B638935BA}")) CIEExtension
	: public CComObjectRoot
	, public CComCoClass<CIEExtension, &__uuidof(CIEExtension)>
	, public IObjectWithSiteImpl<CIEExtension>
	, public IOleCommandTarget
{
public:
	DECLARE_OBJECT_DESCRIPTION("MkImgPage IE Extension Object")

	BEGIN_COM_MAP(CIEExtension)
		COM_INTERFACE_ENTRY(IObjectWithSite)
		COM_INTERFACE_ENTRY(IOleCommandTarget)
	END_COM_MAP( )

	DECLARE_CLASSFACTORY()
	DECLARE_REGISTRY_RESOURCEID(IDR_IEEXTENSION)

	DECLARE_PROTECT_FINAL_CONSTRUCT()

	HRESULT FinalConstruct() throw()
	{
		try {
			HRESULT hr;

			// ^Cg
			if ( !appTitle_.LoadString(IDS_APP_TITLE)) {
				return E_FAIL;
			}

			// e|t@C̃NG[^
			hr = GetTempFileCreator(&pFileCreator_);
			if (FAILED(hr)) {
				return hr;
			}

			// [Uinit@C̃pX
			CComBSTR userIniFile;
			hr = GetShellSpecialFolderBaseDirectory(CSIDL_LOCAL_APPDATA, L"MkImgPage", TRUE, &userIniFile);
			if (FAILED(hr)) {
				return hr;
			}
			userIniFile += L"MkImgPage.ini";

			return GetConfStrageDir(userIniFile, &pConfStrageDir_);
		}
		catch (const CAtlException& exception) {
			return exception.m_hr;
		}
		catch (...) {
			return E_FAIL;
		}
	}
	
	void FinalRelease() throw()
	{
	}

	virtual HRESULT __stdcall QueryStatus(
		const GUID *pguidCmdGroup, // Pointer to command group
		ULONG cCmds,               // Number of commands in prgCmds array
		OLECMD *prgCmds,           // Array of commands
		OLECMDTEXT *pCmdText       // Pointer to name or status of command
		) throw()
	{
		HRESULT hr = IsIdle();
		if (cCmds > 0) {
			for (ULONG idx = 0; idx < cCmds; idx++) {
				prgCmds[idx].cmdf = 0;
				if (SUCCEEDED(hr)) {
					prgCmds[idx].cmdf = OLECMDF_SUPPORTED;
					if (hr == S_OK) {
						// y[W̓ǂݍ݂Ăꍇ̂
						// R}hI\ƂB
						prgCmds[idx].cmdf |= OLECMDF_ENABLED;
					}
				}
			}
		}
		return S_OK;
	}

	virtual HRESULT __stdcall Exec(
		const GUID *pguidCmdGroup,  // Pointer to command group
		DWORD nCmdID,               // Identifier of command to execute
		DWORD nCmdExecOpt,          // Options for executing the command
		VARIANTARG *pvaIn,          // Pointer to input arguments
		VARIANTARG *pvaOut          // Pointer to command output
		) throw()
	{
		HRESULT hr;
		try {
			// uEU̎擾
			CComPtr<IWebBrowser2> pBrowser;
			hr = GetBrowser(&pBrowser);
			if (FAILED(hr)) {
				CString mes;
				mes.LoadString(IDS_BROWSEROBJ_NOT_FOUND);
				::MessageBox(NULL, mes, appTitle_, MB_ICONERROR | MB_OK);
				return OLECMDERR_E_DISABLED;
			}

			HWND hWnd = NULL;
			hr = pBrowser->get_HWND((SHANDLE_PTR*)&hWnd);
			if (FAILED(hr) || hWnd == NULL) {
				hWnd = ::GetActiveWindow();
			}

			try {
				// ev[gRNV̎擾
				CComPtr<ITemplateConfigCollection> pTemplateConfigCollection;
				hr = GetTemplateConfigCollection(&pTemplateConfigCollection);
				bool loadSucceeded = false;
				if (SUCCEEDED(hr)) {
					size_t cnt;
					hr = pTemplateConfigCollection->GetCount(&cnt);
					if (SUCCEEDED(hr)) {
						// ev[g1ȏo^Ă邱ƁB
						loadSucceeded = (cnt >= 1);
					}
				}
				if ( !loadSucceeded) {
					// ev[g̓o^ɖ肪B
					CString mes;
					mes.LoadString(IDS_TEMPLATE_NOTFOUND);
					::MessageBox(hWnd, mes, appTitle_, MB_ICONERROR | MB_OK);
					return E_FAIL;
				}

				// y[W̓ǂݍ݂ĂȂꍇ͐ɐi܂ȂB
				// (R}hs܂ŁAQueryStatus͌ĂяoȂ߁B)
				hr = IsIdle();
				if (FAILED(hr)) AtlThrow(hr);

				if (hr == S_FALSE) {
					CString mes;
					mes.LoadString(IDS_BROWSER_BUSY);
					::MessageBox(hWnd, mes, appTitle_, MB_ICONINFORMATION | MB_OK);
					return OLECMDERR_E_DISABLED;
				}

				// hLg̎擾
				CComPtr<IDispatch> pDocDisp;
				hr = pBrowser->get_Document(&pDocDisp);
				if (FAILED(hr)) AtlThrow(hr);

				CComPtr<IHTMLDocument2> pDoc;
				hr = pDocDisp.QueryInterface(&pDoc);
				if (FAILED(hr)) {
					CString mes;
					mes.LoadString(IDS_HTMLDOCUMENT_NOT_FOUND);
					::MessageBox(hWnd, mes, appTitle_, MB_ICONERROR | MB_OK);
					return OLECMDERR_E_DISABLED;
				}

				// x[X̎擾
				CComBSTR baseURL;
				hr = GetDocumentBase(pDoc, &baseURL);
				if (FAILED(hr)) AtlThrow(hr);

				// ^Cg̎擾
				CComBSTR title;
				hr = GetDocumentTitle(pDoc, &title);
				if (FAILED(hr) || !title) {
					title = L"";
				}

				// ݒ̕
				CComPtr<ISetting> pSetting;
				hr = CreateSetting(&pSetting);
				if (FAILED(hr)) AtlThrow(hr);

				CComPtr<IConfStrage> pConfStrage;
				hr = pConfStrageDir_->OpenStrage(L"MkImgPage", &pConfStrage);
				if (FAILED(hr)) AtlThrow(hr);

				CComQIPtr<IPersistConf> pPersistConf(pSetting);
				hr = pPersistConf->Load(pConfStrage);
				if (FAILED(hr)) {
					CString fmt;
					CString msg;
					fmt.LoadString(IDS_ERROR_LOADSETTINGS);
					msg.Format(fmt, hr);
					::MessageBox(hWnd, msg, appTitle_, MB_ICONWARNING | MB_OK);
					// ǂݍ݂ɎsĂs
				}

				// URL~b^̐ݒ
				CComBSTR baseURLBase;
				hr = GetURLBase(baseURL, &baseURLBase);
				if (FAILED(hr) || !baseURLBase) {
					pSetting->put_URL_Limit(baseURL);
				}
				else {
					pSetting->put_URL_Limit(baseURLBase);
				}

				// URL~b^̐ݒ
				CComPtr<IHTMLLinkCollector> pLinkCollector;
				hr = CreateHTMLLinkCollector(&pLinkCollector);
				if (FAILED(hr)) { AtlThrow(hr); }
				hr = pLinkCollector->DoCollect(pDoc);
				if (FAILED(hr)) { AtlThrow(hr); }

				// ^Cg̐ݒ
				hr = pSetting->put_Title(title);
				if (FAILED(hr)) { AtlThrow(hr); }

				// _CAO̕\
				CSettingDlg dlg;
				dlg.SetSetting(pSetting);
				dlg.SetURLLimitSuggest(pLinkCollector);
				dlg.SetTemplateConfigCollection(pTemplateConfigCollection);
				const INT_PTR ret = dlg.DoModal(hWnd);
				if (ret != IDOK) {
					// LZ
					return OLECMDERR_E_CANCELED;
				}

				// ݒ̕ۑ
				if (pPersistConf->IsDirty() == S_OK) {
					hr = pPersistConf->Save(pConfStrage);
					if (FAILED(hr)) {
						CString fmt;
						CString msg;
						fmt.LoadString(IDS_ERROR_SAVESETTINGS);
						msg.Format(fmt, hr);
						::MessageBox(hWnd, msg, appTitle_, MB_ICONWARNING | MB_OK);
					}
				}

				// ev[gݒ̎擾
				CComBSTR templateName;
				hr = pSetting->get_TemplateName(&templateName);
				if (FAILED(hr)) { AtlThrow(hr); }

				CComPtr<ITemplateConfig> pTemplateConfig;
				hr = pTemplateConfigCollection->FindTemplateConfig(templateName, &pTemplateConfig);
				if (FAILED(hr)) { AtlThrow(hr); }

				// tB^̎sƌʂ̎擾
				CComPtr<IScriptObject> pResultObject;
				hr = DoFilter(pDoc, pSetting, &pResultObject);
				if (FAILED(hr)) {
					CAtlString msg, fmt;
					fmt.LoadString(IDS_DOCUMENT_FILTER_ERROR);
					msg.Format(fmt, hr);
					::MessageBox(hWnd, msg, appTitle_, MB_ICONERROR | MB_OK);
					return E_FAIL;
				}

				// \ڐ̐
				hr = CheckPerformanceGuard(hWnd, pTemplateConfig, pResultObject);
				if (hr != S_OK) {
					return OLECMDERR_E_CANCELED;
				}

				// ǉ̏̐ݒ
				hr = pResultObject->put_item(
					CComVariant(L"baseLocation"), CComVariant(baseURL));
				if (FAILED(hr)) AtlThrow(hr);
				hr = pResultObject->put_item(
					CComVariant(L"document"), CComVariant(pDoc));
				if (FAILED(hr)) AtlThrow(hr);

				CComPtr<IScriptObject> pConfigObject;
				hr = CreateScriptObject(&pConfigObject);
				if (FAILED(hr)) AtlThrow(hr);

				hr = pSetting->SetToScriptObject(pConfigObject);
				if (FAILED(hr)) AtlThrow(hr);

				pResultObject->put_item(
					CComVariant("config"), CComVariant(pConfigObject));
				if (FAILED(hr)) AtlThrow(hr);


				// ʃt@C̍쐬
				CComBSTR filePath;
				CComBSTR errorMessage;
				hr = MakeResultDocument(pTemplateConfig, pResultObject, &filePath, &errorMessage);
				if (FAILED(hr)) {
					CAtlString msg;
					if (errorMessage) {
						// XNvgGW̃G[bZ[W̕\
						CAtlString fmt;
						fmt.LoadString(IDS_TEMPLATE_MAKE_ERROR);
						msg.Format(fmt, CW2T(errorMessage));
					}
					else {
						CAtlString fmt;
						fmt.LoadString(IDS_TEMPLATE_MAKE_ERROR2);
						msg.Format(fmt, hr);
					}
					::MessageBox(hWnd, msg, appTitle_, MB_ICONERROR | MB_OK);
					return E_FAIL;
				}

				// \
				CComVariant targetURL(filePath);
				CComVariant targetWindow;
				CComVariant flags;
				if (pSetting->is_OpenNewWindow() == S_OK) {
					targetWindow = L"_blank";
					flags = navOpenInNewWindow;
				}
				else {
					targetWindow = L"_top";
					flags = 0;
				}
				CComVariant postData, headers;

				hr = pBrowser->Navigate2(
					&targetURL,
					&flags,
					&targetWindow,
					&postData,
					&headers
					);
				if (FAILED(hr)) AtlThrow(hr);

				return S_OK;
			}
			catch (const CAtlException& exception) {
				CString fmt;
				CString message;
				fmt.LoadString(IDS_ERROR_HRESULT);
				message.Format(fmt, exception.m_hr);
				::MessageBox(hWnd, message, appTitle_, MB_ICONERROR | MB_OK);
				return E_FAIL;
			}
		}
		catch (...) {
			CString fmt;
			fmt.LoadString(IDS_ERROR_UNKNOWN);
			::MessageBox(NULL, fmt, appTitle_, MB_ICONERROR | MB_OK);
			return E_FAIL;
		}
	}

	/**
	 * ev[gݒt@CAev[g`ǂݍ݂܂B
	 * @param v_ppTemplateConfigCollection ev[g`RNVi[|C^
	 * @return HR
	 */
	HRESULT GetTemplateConfigCollection(ITemplateConfigCollection** v_ppTemplateConfigCollection)
	{
		ATLASSERT(v_ppTemplateConfigCollection);
		ATLASSERT(!*v_ppTemplateConfigCollection);

		HRESULT hr;

		// ev[g̃ftHgl̎擾

		CComPtr<IConfStrage> pTemplateDefaultStrage;
		hr = pConfStrageDir_->OpenStrage(L"TemplateDefault", &pTemplateDefaultStrage);
		if (FAILED(hr)) return hr;

		CComPtr<ITemplateConfigFactory> pConfigFactory;
		hr = CreateTemplateConfigFactory(&pConfigFactory);
		if (FAILED(hr)) return hr;

		CComPtr<ITemplateConfig> pTemplateDefaultConfig;
		hr = LoadTemplateConfig(pTemplateDefaultStrage, pConfigFactory, NULL, &pTemplateDefaultConfig);
		if (FAILED(hr)) return hr;

		// ev[g`t@C

		CComBSTR templateBaseDir;
		hr = GetModuleBaseDirectory(
			_AtlBaseModule.GetModuleInstance(),
			L"templates",
			FALSE,
			&templateBaseDir
			);
		if (FAILED(hr)) return hr;

		CAtlStringW templateIniFile(templateBaseDir);
		templateIniFile += L"templates.ini";

		CComPtr<IConfStrageDir> pTemplateConfStrageDir;
		hr = GetConfStrageDir(templateIniFile, &pTemplateConfStrageDir);
		if (FAILED(hr)) return hr;

		// ev[gݒRNṼ[h

		hr = pConfigFactory->SetBaseDirectory(templateBaseDir);
		if (FAILED(hr)) return hr;

		CComPtr<ITemplateConfigCollection> pTemplateConfigCollection;
		hr = LoadTemplateConfigCollection(
			pTemplateConfStrageDir,
			pConfigFactory,
			pTemplateDefaultConfig,
			&pTemplateConfigCollection
			);
		if (FAILED(hr)) return hr;

		return pTemplateConfigCollection.CopyTo(v_ppTemplateConfigCollection);
	}

	/**
	 * XNvgIuWFNgɃptH[}Xɉêi[Ă
	 * x_CAO\B
	 * @param v_hWnd _CAO\eEBhE
	 * @param v_pScriptObject XNvgIuWFNg
	 * @return S_OKȂΕ\\AS_FALSEȂ璆fBG[Ȃ΃G[R[h
	 */
	HRESULT CheckPerformanceGuard(HWND v_hWnd, ITemplateConfig* v_pTemplateConfig, IScriptObject* v_pScriptObject)
	{
		ATLASSERT(v_pTemplateConfig);
		ATLASSERT(v_pScriptObject);

		HRESULT hr;
		
		int maxIFrame = 0;
		hr = v_pTemplateConfig->GetMaxIFrame(&maxIFrame);
		if (FAILED(hr)) {
			return hr;
		}
		if (maxIFrame < 0) {
			// sv
			return S_OK;
		}

		CComVariant varIFrames;
		hr = v_pScriptObject->get_item(CComVariant("iframe"), &varIFrames);
		if (FAILED(hr)) {
			ATLASSERT(false);
			return hr;
		}
		hr = varIFrames.ChangeType(VT_DISPATCH);
		if (FAILED(hr)) {
			ATLASSERT(false);
			return hr;
		}

		CComQIPtr<IScriptObject> pFrames(varIFrames.pdispVal);
		ATLASSERT(pFrames);

		long len;
		hr = pFrames->get_length(&len);
		if (FAILED(hr)) return hr;

		if (maxIFrame <= len) {
			// lI[o[Ă
			CString fmt;
			CString msg;
			fmt.LoadString(IDS_WARNING_TOOMANY_IFRAMES);
			msg.Format(fmt, len, maxIFrame);

			int ret = ::MessageBox(v_hWnd, msg, appTitle_, MB_ICONWARNING | MB_YESNO);

			return (ret == IDYES) ? S_OK : S_FALSE;
		}

		return S_OK;
	}

	/**
	 * oʂt@CɏށB
	 * G[bZ[W擾ꂽꍇAG[bZ[W̊i[|C^ɃZbg܂B
	 * @param v_pScriptObject o
	 * @param v_pOutputStm o͐
	 * @param v_pErrorMessage G[bZ[Wi[|C^
	 * @return HR
	 */
	HRESULT MakeResultDocument(ITemplateConfig* v_pTemplateConfig,
							   IScriptObject* v_pScriptObject,
							   BSTR* v_pOutputFileName,
							   BSTR* v_pErrorMessage
							   ) throw()
	{
		ATLASSERT(v_pTemplateConfig);
		ATLASSERT(v_pScriptObject);
		ATLASSERT(v_pOutputFileName);
		ATLASSERT(v_pErrorMessage);

		HRESULT hr;

		try {
			// XNvgr_̍\z

			CComPtr<IScriptBuilder> pScriptBuilder;
			hr = CreateScriptBuilder(__uuidof(VBScript), &pScriptBuilder);
			if (FAILED(hr)) return hr;

			CComPtr<ITemplateSourceChunkBuilder> pChunkBuilder;
			hr = CreateTemplateSourceChunkBuilder(&pChunkBuilder);
			if (FAILED(hr)) return hr;

			CComPtr<ITemplateSourceProcessor> pChunkWriterProcessor;
			hr = CreateTemplateSourceEncodingProcessor(pScriptBuilder, &pChunkWriterProcessor);
			if (FAILED(hr)) return hr;

			hr = pChunkBuilder->RegisterProcessor(pChunkWriterProcessor);
			if (FAILED(hr)) return hr;

			CComPtr<ITemplateSourceSplitter> pReader;
			hr = CreateTemplateSourceSplitter(pChunkBuilder, &pReader);
			if (FAILED(hr)) return hr;

			// ev[gt@C̓ǂݍ

			CComBSTR templateFilePath;
			hr = v_pTemplateConfig->GetFileName(&templateFilePath);
			if (FAILED(hr)) {
				return hr;
			}

			CComPtr<IStream> pStm;
			hr = SHCreateStreamOnFile(
				templateFilePath,
				STGM_READ | STGM_SHARE_DENY_WRITE,
				&pStm);
			if (FAILED(hr)) return hr;

			hr = pReader->Parse(pStm);
			if (FAILED(hr)) return hr;

			pStm.Release();

			// o͐t@C̍쐬
			
			CComPtr<IFileName> pFileName;
			hr = pFileCreator_->Create(&pFileName);
			if (FAILED(hr)) AtlThrow(hr);

			CComPtr<IStream> pOutputStm;
			hr = pFileName->GetStream(&pOutputStm);
			if (FAILED(hr)) AtlThrow(hr);

			// IuWFNg̓o^

			hr = pScriptBuilder->SetOutputStream(pOutputStm);
			if (FAILED(hr)) return hr;

			hr = pScriptBuilder->RegistExternalObject(L"ext", v_pScriptObject);
			if (FAILED(hr)) return hr;

			// ev[g̎s

			hr = pScriptBuilder->Execute(v_pErrorMessage);
			if (FAILED(hr)) return hr;

			// t@Ci[
			
			hr = pFileName->get_Path(v_pOutputFileName);
			if (FAILED(hr)) return hr;

			return S_OK;
		}
		catch (const CAtlException& exception) {
			return exception.m_hr;
		}
		catch (...) {
			return E_FAIL;
		}
	}

	/**
	 * hLgx[X擾B
	 * hLgɃx[Xvf΁ApB
	 * ݂Ȃ
	 */
	HRESULT GetDocumentBase(IHTMLDocument2* v_pDoc, BSTR* v_pBaseURL)
	{
		ATLASSERT(v_pDoc);
		ATLASSERT(v_pBaseURL);
		ATLASSERT( !*v_pBaseURL);

		HRESULT hr;

		CComPtr<IHTMLElementCollection> pAll;
		hr = v_pDoc->get_all(&pAll);
		if (FAILED(hr)) AtlThrow(hr);

		CComPtr<IDispatch> pBaseDisp;
		hr = pAll->tags(CComVariant(L"base"), &pBaseDisp);
		if (FAILED(hr)) AtlThrow(hr);
		CComQIPtr<IHTMLElementCollection> pBaseTags(pBaseDisp);
		long baseTagsCnt;
		hr = pBaseTags->get_length(&baseTagsCnt);
		if (FAILED(hr)) AtlThrow(hr);

		CComBSTR baseURL;
		if (baseTagsCnt > 0) {
			CComVariant idx(0);
			CComVariant dmy;
			CComPtr<IDispatch> pBaseTagDisp;
			hr = pBaseTags->item(idx, dmy, &pBaseTagDisp);
			if (FAILED(hr)) AtlThrow(hr);
			CComQIPtr<IHTMLBaseElement> pBaseTag(pBaseTagDisp);
			if ( !pBaseTag) { AtlThrow(E_NOINTERFACE); }
			hr = pBaseTag->get_href(&baseURL);
			if (FAILED(hr)) AtlThrow(hr);

			if (baseURL && baseURL.Length() == 0) {
				baseURL.Empty();
			}
		}
		if ( !baseURL) {
			// x[Xw肳ĂȂ΁ÃhLg̃P[Vgp
			if (FAILED(v_pDoc->get_URL(&baseURL)) || baseURL == NULL) {
				baseURL = L"";
			}
		}

		*v_pBaseURL = baseURL.Detach();
		return S_OK;
	}

	/**
	 * ^Cg擾܂B
	 * @param v_pDoc hLg
	 * @param v_pTitle ^Cg̊i[|C^
	 * @return HR
	 */
	HRESULT GetDocumentTitle(IHTMLDocument2* v_pDoc, BSTR* v_pTitle)
	{
		ATLASSERT(v_pDoc);
		ATLASSERT(v_pTitle);
		ATLASSERT(!*v_pTitle);

		return v_pDoc->get_title(v_pTitle);
	}

	/**
	 * ݒɊÂăhLg烊N𒊏oAʂ擾B
	 * @param v_pDoc hLg
	 * @param v_pSetting ݒ
	 * @param v_ppResultObject ʂi[ꂽIuWFNgi[|C^
	 * @return HR
	 */
	HRESULT DoFilter(IHTMLDocument2* v_pDoc, ISetting* v_pSetting, IScriptObject** v_ppResultObject) throw()
	{
		ATLASSERT(v_pDoc);
		ATLASSERT(v_pSetting);
		ATLASSERT(v_ppResultObject);

		try {
			HRESULT hr;

			// tB^ݒ̍\z
			CComPtr<ISettingAcceptors> pSettingAcceptors;
			hr = CreateSettingAcceptors(v_pSetting, &pSettingAcceptors);
			if (FAILED(hr)) {
				AtlThrow(hr);
			}

			// HTMLvftB^̍\z
			CComPtr<IHTMLElementFilter> pHTMLElementFilter;
			hr = CreateHTMLElementFilter(&pHTMLElementFilter);
			if (FAILED(hr)) {
				AtlThrow(hr);
			}
			hr = pHTMLElementFilter->put_Setting(pSettingAcceptors);
			if (FAILED(hr)) {
				AtlThrow(hr);
			}

			// tB^̎s
			hr = pHTMLElementFilter->DoFilter(v_pDoc);
			if (FAILED(hr)) {
				AtlThrow(hr);
			}

			return pHTMLElementFilter->GetCollection(v_ppResultObject);
		}
		catch (const CAtlException& exception) {
			return exception.m_hr;
		}
		catch (...) {
			return E_FAIL;
		}
	}

	/**
	 * SiteuEU擾B
	 * 擾łȂꍇ̓G[R[hԂB
	 */
	HRESULT GetBrowser(IWebBrowser2** ppBrowser) throw()
	{
		if ( !ppBrowser) {
			return E_POINTER;
		}
		try {
			if ( !m_spUnkSite) {
				return E_FAIL;
			}

			HRESULT hr;

			CComPtr<IServiceProvider> pServiceProvider;
			hr = m_spUnkSite.QueryInterface(&pServiceProvider);
			if (FAILED(hr)) return hr;

			CComPtr<IServiceProvider> pTopLevelBrowser;
			hr = pServiceProvider->QueryService(SID_STopLevelBrowser, &pTopLevelBrowser);
			if (FAILED(hr)) return hr;

			hr = pTopLevelBrowser->QueryService(SID_SWebBrowserApp, ppBrowser);
			if (FAILED(hr)) return hr;

			return S_OK;
		}
		catch (...) {
			return E_FAIL;
		}
	}

	/**
	 * uEUAChł邩`FbNB
	 * uEUAChłS_OKAłȂS_FALSEԂB
	 * uEUɃANZXłȂꍇ̓G[R[hԂB
	 */
	HRESULT IsIdle() throw()
	{
		try {
			HRESULT hr;
			CComPtr<IWebBrowser2> pBrowser;
			hr = GetBrowser(&pBrowser);
			if (FAILED(hr)) return hr;
			
			VARIANT_BOOL busy;
			hr = pBrowser->get_Busy(&busy);
			if (FAILED(hr)) return hr;

			return (busy == VARIANT_TRUE) ? S_FALSE : S_OK;
		}
		catch (...) {
			return E_FAIL;
		}
	}

protected:

	CString appTitle_;

	CComPtr<IConfStrageDir> pConfStrageDir_;

	CComPtr<IFileCreator> pFileCreator_;
};

OBJECT_ENTRY_AUTO(__uuidof(CIEExtension), CIEExtension);
