#pragma once

#include <memory.h>
#include <atlcoll.h>

/**
 * VvȔzێNXB
 * Az̖͏0ŃpfBOĂ܂B
 */
template<typename E>
class CSimpleBuffer
{
public:

	/**
	 * ̔z\z܂B
	 */
	CSimpleBuffer()
	{
		buf_.Add(0);
	}

	/**
	 * 0Ŗ߂ꂽw肳ꂽ̔z\z܂B
	 * ɂ0t^܂B
	 */
	CSimpleBuffer(size_t v_siz)
	{
		buf_.SetCount(v_siz + 1);
	}

	/**
	 * Rs[RXgN^
	 * @param v_src Rs[
	 */
	CSimpleBuffer(const CSimpleBuffer& v_src)
	{
		operator=(v_src);
	}

	/**
	 * zw肵č\z܂B
	 * @param v_pSrc z
	 * @param v_siz vf
	 */
	explicit CSimpleBuffer(const E* v_pSrc, size_t v_siz)
	{
		if (v_siz > 0) {
			if ( !buf_.SetCount(v_siz + 1)) {
				AtlThrow(E_OUTOFMEMORY);
			}
			E* pBuf = buf_.GetData();
			ATLASSERT(pBuf);

			memcpy(pBuf, v_pSrc, sizeof(E) * v_siz);
			*(pBuf + v_siz) = 0;
		}
	}

	/**
	 * Rs[
	 * @param v_src Rs[
	 * @return ̃ItWFNg
	 */
	CSimpleBuffer& operator=(const CSimpleBuffer& v_src)
	{
		if (&v_src != this) {
			buf_.RemoveAll();
			buf_.Append(v_src.buf_);
		}
		return *this;
	}

	/**
	 * fXgN^
	 */
	~CSimpleBuffer() throw()
	{
	}

	void Clear()
	{
		buf_.RemoveAll();
		buf_.Add(0);
	}

	/**
	 * vfǉ܂
	 * @param c oCg
	 */
	void Add(E c)
	{
		buf_.SetAt(buf_.GetCount() - 1, c);
		buf_.Add(0);
	}

	/**
	 * vfzǉ܂
	 * @param v_pSrc z
	 * @param v_siz vf
	 */
	void Append(const E* v_pSrc, size_t v_siz)
	{
		if (v_siz > 0) {
			size_t pos = buf_.GetCount() - 1;
			if ( !buf_.SetCount(pos + v_siz + 1)) {
				AtlThrow(E_OUTOFMEMORY);
			}
			E* pBuf = buf_.GetData();
			ATLASSERT(pBuf);
			memcpy(pBuf + pos, v_pSrc, sizeof(E) * v_siz);
			*(pBuf + pos + v_siz) = 0;
		}
	}

	/**
	 * i[ĂvfԂ܂B
	 * @return vf
	 */
	size_t GetCount() const throw()
	{
		return buf_.GetCount() - 1;
	}

	/**
	 * vf̌ݒ肵܂B
	 * ݂g傳ꍇ0߂܂B
	 * @param v_siz vf̌
	 */
	void SetCount(size_t v_siz)
	{
		size_t prev = buf_.GetCount();
		if (v_siz + 1 == prev) {
			// TCYɕύXȂ
			return;
		}

		buf_.SetCount(v_siz + 1);
		if (prev > v_siz) {
			// kނ̏ꍇ͖0ɒu
			buf_.SetAt(v_siz, 0);
		}
	}

	/**
	 * i[Ăz擾܂B
	 * z̖ɂ͕K0t^܂B(i[ɂ̓[͊܂݂܂)
	 * 0̏ꍇAԂzɂ0݂̂i[Ă܂B
	 */
	const E* GetData() const throw()
	{
		return buf_.GetData();
	}

	/**
	 * i[Ăz擾܂B
	 * z̖ɂ͕K0t^܂B(i[ɂ̓[͊܂݂܂)
	 * 0̏ꍇAԂzɂ0݂̂i[Ă܂B
	 */
	E* GetData() throw()
	{
		return buf_.GetData();
	}

private:

	CAtlArray<E> buf_;
};
