package jp.gr.java_conf.ka_ka_xyz.util;

import jp.gr.java_conf.ka_ka_xyz.util.Log;

public class PreferenceUtils {

	private PreferenceUtils() {
	}

	public static final String PMDPATH = "PMDPATH";
	public static final String VMDPATH = "VMDPATH";
	public static final String SCALE_PROGRESS = "SCALE_PROGRESS";
	public static final String SCALE_ENABLED = "SCALE_ENABLED";

	public static final int MAX_PROGRESS = 20;

	/**
	 * プログレスバーの値（0～10、整数型）を倍率へ変換
	 * */
	public static double convertProgressToScale(int progress) {
		progress = progress + 1;
		double rtn;
		if (progress < MAX_PROGRESS / 2) {
			rtn = (double) progress / 10;
		} else {
			rtn = (double) (progress - 9);
		}
		Log.d("PREFERENCE", progress + ", " + MAX_PROGRESS / 2);
		return rtn;
	}
}
