package jp.gr.java_conf.ka_ka_xyz.activities;

import java.io.File;

import com.lamerman.FileDialog;

import jp.gr.java_conf.ka_ka_xyz.R;
import jp.gr.java_conf.ka_ka_xyz.util.PreferenceUtils;
import android.app.Activity;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.preference.PreferenceManager;
import jp.gr.java_conf.ka_ka_xyz.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.CompoundButton.OnCheckedChangeListener;
import android.widget.EditText;
import android.widget.SeekBar;
import android.widget.SeekBar.OnSeekBarChangeListener;
import android.widget.TextView;

public class MmdARoidPreferences extends Activity {

	private SharedPreferences sp;

	private EditText pmdPath = null;
	private EditText vmdPath = null;

	private SeekBar scaleSeekBar = null;
	private TextView scaleText = null;

	private Button acceptBtn = null;
	private Button cancelBtn = null;

	private boolean enableScale;

	private static final int REQUEST_FOR_PMDFILEPATH = 100;
	private static final int REQUEST_FOR_VMDFILEPATH = 200;

	@Override
	public void onCreate(Bundle savedInstanceState) {
		setContentView(R.layout.settings);
		super.onCreate(savedInstanceState);
		sp = PreferenceManager.getDefaultSharedPreferences(this);
	}

	@Override
	public void onStart() {
		super.onStart();

		load();
		initPmdFileViews();
		initVmdFileViews();
		initModelSchale();
		initAcceptBtn();
		initCancelBtn();
		setCancelBtnEneabled();
		setAcceptBtnEneabled();

	}

	private void initPmdFileViews() {
		final String initPmdPath;
		if (pmdPath == null) {
			pmdPath = (EditText) findViewById(R.id.pref_mmdfile_textedit);
			initPmdPath = sp.getString(PreferenceUtils.PMDPATH, "");
		} else {
			initPmdPath = pmdPath.getText().toString();
		}

		File pmd = new File(initPmdPath);
		final String initPmdDir;
		if (pmd.exists() && pmd.isFile()) {
			initPmdDir = pmd.getParentFile().getAbsolutePath();
		} else if (pmd.isDirectory()) {
			initPmdDir = pmd.getAbsolutePath();
		} else {
			initPmdDir = "/";
		}
		pmdPath.setText(initPmdPath);
		pmdPath.setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View v) {
				Intent intent = new Intent(MmdARoidPreferences.this,
						FileDialog.class);
				if (initPmdPath == null || "".equals(initPmdPath)) {
					intent.putExtra(FileDialog.START_PATH, "/");
				} else {
					intent.putExtra(FileDialog.START_PATH, initPmdDir);
				}
				intent.putExtra(FileDialog.EXTENTION_FILTER,
						new String[] { "pmd" });
				startActivityForResult(intent, REQUEST_FOR_PMDFILEPATH);
			}
		});
	}

	private void initVmdFileViews() {
		final String initVmdPath;
		if (vmdPath == null) {
			vmdPath = (EditText) findViewById(R.id.pref_vmdfile_textedit);
			initVmdPath = sp.getString(PreferenceUtils.VMDPATH, "");
		} else {
			initVmdPath = vmdPath.getText().toString();
		}
		File vmd = new File(initVmdPath);
		final String initVmdDir;
		if (vmd.exists() && vmd.isFile()) {
			initVmdDir = vmd.getParentFile().getAbsolutePath();
		} else if (vmd.isDirectory()) {
			initVmdDir = vmd.getAbsolutePath();
		} else {
			initVmdDir = "/";
		}

		vmdPath.setText(initVmdPath);
		vmdPath.setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View v) {
				Intent intent = new Intent(MmdARoidPreferences.this,
						FileDialog.class);
				if (initVmdPath == null || "".equals(initVmdPath)) {
					intent.putExtra(FileDialog.START_PATH, "/");
				} else {
					intent.putExtra(FileDialog.START_PATH, initVmdDir);
				}
				intent.putExtra(FileDialog.EXTENTION_FILTER,
						new String[] { "vmd" });
				startActivityForResult(intent, REQUEST_FOR_VMDFILEPATH);
			}
		});
	}

	private void initModelSchale() {

		CheckBox chk = (CheckBox) findViewById(R.id.pref_scale_chk);
		enableScale = sp.getBoolean(PreferenceUtils.SCALE_ENABLED, false);
		chk.setChecked(enableScale);
		chk.setOnCheckedChangeListener(new OnCheckedChangeListener() {

			@Override
			public void onCheckedChanged(CompoundButton buttonView,
					boolean isChecked) {
				scaleSeekBar.setEnabled(isChecked);
				enableScale = isChecked;
			}
		});

		if (scaleSeekBar == null) {
			scaleSeekBar = (SeekBar) findViewById(R.id.pref_scale_seekbar);
		}
		scaleSeekBar.setEnabled(enableScale);

		final int initProgress = sp.getInt(PreferenceUtils.SCALE_PROGRESS, 10);
		scaleSeekBar.setMax(PreferenceUtils.MAX_PROGRESS);
		scaleSeekBar.setProgress(initProgress);

		scaleText = (TextView) findViewById(R.id.pref_scale_text);
		scaleText.setText(String.valueOf(PreferenceUtils
				.convertProgressToScale(scaleSeekBar.getProgress())));

		scaleSeekBar.setOnSeekBarChangeListener(new OnSeekBarChangeListener() {

			@Override
			public void onProgressChanged(SeekBar seekBar, int progress,
					boolean fromUser) {
				scaleText.setText(String.valueOf(PreferenceUtils
						.convertProgressToScale(progress)));
			}

			@Override
			public void onStartTrackingTouch(SeekBar seekBar) {
			}

			@Override
			public void onStopTrackingTouch(SeekBar seekBar) {
			}
		});
	}

	public synchronized void onActivityResult(final int requestCode,
			int resultCode, final Intent data) {

		if (resultCode == Activity.RESULT_OK) {

			if (requestCode == REQUEST_FOR_PMDFILEPATH) {
				if (pmdPath == null) {
					initPmdFileViews();
				}
				pmdPath.setText(data.getStringExtra(FileDialog.RESULT_PATH));

			} else if (requestCode == REQUEST_FOR_VMDFILEPATH) {
				if (vmdPath != null) {
					initVmdFileViews();
				}
				vmdPath.setText(data.getStringExtra(FileDialog.RESULT_PATH));
			}

		}
	}

	private void initCancelBtn() {
		cancelBtn = (Button) findViewById(R.id.pref_cancel);
		cancelBtn.setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View v) {
				finish();
			}
		});
	}

	private void initAcceptBtn() {
		acceptBtn = (Button) findViewById(R.id.pref_accept);
		acceptBtn.setOnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View v) {
				save();
				finish();
			}
		});
	}

	private void save() {
		sp.edit()
				.putString(PreferenceUtils.PMDPATH,
						this.pmdPath.getText().toString()).commit();
		sp.edit()
				.putString(PreferenceUtils.VMDPATH,
						this.vmdPath.getText().toString()).commit();
		sp.edit()
				.putInt(PreferenceUtils.SCALE_PROGRESS,
						this.scaleSeekBar.getProgress()).commit();
		sp.edit().putBoolean(PreferenceUtils.SCALE_ENABLED, this.enableScale)
				.commit();
	}

	private void load() {
	}

	private void setAcceptBtnEneabled() {
		if (this.acceptBtn != null) {
			boolean enabled = true;
			if (pmdPath == null || "".equals(pmdPath.getText().toString())
					|| vmdPath == null
					|| "".equals(vmdPath.getText().toString())) {
				enabled = false;
			}
			acceptBtn.setEnabled(enabled);
		}
	}

	private void setCancelBtnEneabled() {

		if (this.cancelBtn != null) {
			boolean enabled = true;
			if (pmdPath == null || "".equals(pmdPath.getText().toString())
					|| vmdPath == null
					|| "".equals(vmdPath.getText().toString())) {
				enabled = false;
			}
			cancelBtn.setEnabled(enabled);
		}

	}

}
