using UnityEngine;
using System.Collections;
using UnityEditor;


public class PMDLoaderWindow : EditorWindow {
	Object pmdFile = null;
	
	[MenuItem ("Plugins/MMD Loader/PMD Loader")]
	static void Init() {
		var window = (PMDLoaderWindow)EditorWindow.GetWindow<PMDLoaderWindow>(true, "PMDLoader");
		window.Show();
	}
	
	void OnGUI() {
		const int height = 20;
		
		pmdFile = EditorGUI.ObjectField(
			new Rect(0, 0, position.width-16, height), "PMD File" ,pmdFile, typeof(Object));
		
		if (pmdFile != null) {
			if (GUI.Button(new Rect(0, height+2, position.width/2, height), "Convert")) {
				PMDLoaderScript pmdLoader = new PMDLoaderScript(pmdFile);
				pmdFile = null;		// 読み終わったので空にする 
			}
		} else {
			EditorGUI.LabelField(new Rect(0, height+2, position.width, height), "Missing", "Select PMD File");
		}
	}
}
