//
// ManagerAccessor.hpp
//

#pragma once

#include <memory>

class CardManager;
typedef std::shared_ptr<CardManager> CardManagerPtr;
typedef std::weak_ptr<CardManager> CardManagerWeakPtr;

class PlayerManager;
typedef std::shared_ptr<PlayerManager> PlayerManagerPtr;
typedef std::weak_ptr<PlayerManager> PlayerManagerWeakPtr;

class CommandManager;
typedef std::shared_ptr<CommandManager> CommandManagerPtr;
typedef std::weak_ptr<CommandManager> CommandManagerWeakPtr;

class WorldManager;
typedef std::shared_ptr<WorldManager> WorldManagerPtr;
typedef std::weak_ptr<WorldManager> WorldManagerWeakPtr;

class AccountManager;
typedef std::shared_ptr<AccountManager> AccountManagerPtr;
typedef std::weak_ptr<AccountManager> AccountManagerWeakPtr;

class ConfigManager;
typedef std::shared_ptr<ConfigManager> ConfigManagerPtr;
typedef std::weak_ptr<ConfigManager> ConfigManagerWeakPtr;

class ManagerAccessor {
    public:
        ManagerAccessor(const CardManagerWeakPtr& card_manager,
                const PlayerManagerWeakPtr& player_manager);
        ManagerAccessor();

        const CardManagerWeakPtr& card_manager();
        void set_card_manager(CardManagerWeakPtr card_manager);
        const PlayerManagerWeakPtr& player_manager();
        void set_player_manager(PlayerManagerWeakPtr player_manager);
        const CommandManagerWeakPtr& command_manager();
        void set_command_manager(CommandManagerWeakPtr command_manager);
        const WorldManagerWeakPtr& world_manager();
        void set_world_manager(WorldManagerWeakPtr world_manager);
        const AccountManagerWeakPtr& account_manager();
        void set_account_manager(AccountManagerWeakPtr account_manager);
        const ConfigManagerWeakPtr& config_manager();
        void set_config_manager(ConfigManagerWeakPtr config_manager);

    private:
        CardManagerWeakPtr card_manager_;
        PlayerManagerWeakPtr player_manager_;
        CommandManagerWeakPtr command_manager_;
        WorldManagerWeakPtr world_manager_;
        AccountManagerWeakPtr account_manager_;
        ConfigManagerWeakPtr config_manager_;
};

typedef std::shared_ptr<ManagerAccessor> ManagerAccessorPtr;
