//
// unicode.cpp
//

#include "unicode.hpp"
#include <DxLib.h>

namespace unicode {
    std::string sjis2utf8(std::string in) {

        int wchar_size = ::MultiByteToWideChar(CP_ACP,0,in.data(),in.size(),nullptr,0);
        wchar_t wchar_buf[wchar_size];
        ::MultiByteToWideChar(CP_ACP,0,in.data(),in.size(),wchar_buf,wchar_size);

        int utf8_size = ::WideCharToMultiByte(CP_UTF8,0,wchar_buf,wchar_size,nullptr,0,nullptr,nullptr);
        char utf8_buf[utf8_size];
        ::WideCharToMultiByte(CP_UTF8,0,wchar_buf,wchar_size,utf8_buf,utf8_size,nullptr,nullptr);

        return std::string(utf8_buf, utf8_size);
    }

    std::string utf82sjis(std::string in) {

        int wchar_size = ::MultiByteToWideChar(CP_UTF8,0,in.data(),in.size(),nullptr,0);
        wchar_t wchar_buf[wchar_size];
        ::MultiByteToWideChar(CP_UTF8,0,in.data(),in.size(),wchar_buf,wchar_size);

        int sjis_size = ::WideCharToMultiByte(CP_ACP,0,wchar_buf,wchar_size,nullptr,0,nullptr,nullptr);
        char sjis_buf[sjis_size];
        ::WideCharToMultiByte(CP_ACP,0,wchar_buf,wchar_size,sjis_buf,sjis_size,nullptr,nullptr);

        return std::string(sjis_buf, sjis_size);
    }
}
