//
// FormatString.hpp
//

#pragma once
#include <boost/format.hpp>

namespace FormatString {
        template<class FormatType>
        std::string Format(FormatType format)
        {
            return format.str();
        }

        template<class FormatType, class First>
        std::string Format(FormatType format, First first)
        {
            return Format(format % first);
        }

        template<class FormatType, class First, class... Rest>
        std::string Format(FormatType format, First first, Rest... rest)
        {
            return Format(format % first, rest...);
        }

        template<class... Params>
        std::string New(const std::string& format, Params... params) {
            return Format(boost::format(format), params...);
        }
}
