//
// Stmt.hpp
//

#pragma once
#include <string>
#include <sqlite3.h>

namespace SQLite {

class Client {
    public:
        Client(const std::string& name);
        ~Client();

        int Exec(const std::string& sql);

        std::string ErrorMsg() const;
        sqlite3* db() const;

    private:
        sqlite3 *db_;
};

class Stmt {
    public:
        Stmt(const Client& client, const std::string& sql);
        ~Stmt();

        int Step();
        int Reset();

        int Bind(int column, int value);
        int Bind(int column, const std::string& value);

        int IntValue(int column);
        std::string TextValue(int column);

    private:
        sqlite3_stmt *stmt_;

};

}
