//
// Encrypter.hpp
//

#pragma once

#include <string>
#include <openssl/ecdsa.h>
#include <openssl/obj_mac.h>
#include <openssl/evp.h>
#include <openssl/rsa.h>
#include <openssl/hmac.h>

namespace network {

class Encrypter {
    public:
        Encrypter();
        ~Encrypter();

        std::string Encrypt(const std::string&);
        std::string Decrypt(const std::string&);

        std::string PublicEncrypt(const std::string&);
        std::string PublicDecrypt(const std::string&);

        std::string Sign(const std::string&);
        bool Verify(const std::string& in, const std::string& sign);

        std::string GetPublicKey();
        void SetPublicKey(const std::string&);
        std::string GetPrivateKey();
        void SetPrivateKey(const std::string&);
        void SetPairKey(const std::string&, const std::string&);
        bool CheckKeyPair();

        std::string GetCryptedCommonKey();
        void SetCryptedCommonKey(const std::string&);

        std::string GetPublicKeyFingerPrint();
        static std::string GetHash(const std::string&);
        static std::string GetTrip(const std::string&);

    private:
        std::string GetCommonKey();
        static std::string GetTripHash(const std::string&);

    public:
        // 共通鍵の長さ
        constexpr static int COMMON_KEY_LENGTH = 16;    // 128bit

        // 共通鍵の初期化ベクトルの長さ
        constexpr static int COMMON_KEY_IV_LENGTH = 16;

        // RSA鍵の長さ
        constexpr static int RSA_KEY_LENGTH = 256;      // 2048bit

        // SHAハッシュの長さ
        constexpr static int SHA_LENGTH = 64;           // 512bit

        // トリップの長さ
        constexpr static int TRIP_LENGTH = 20;

    private:
        // フィンガープリント用ハッシュで用いるHMACパスワード
        // ** 警告 ** この値を変更すると、変更以前に登録したフィンガープリントが全て無効になります。
        constexpr const static char* SHA_HMAC_KEY =
                "TXpnM01XVTJNemRrTlRSa1pqUXlZVEUxWm1Rd1lqVmhNelkxTWpFMVpHTQ==";

        // トリップ用ハッシュで用いるHMACパスワード
        // ** 警告 ** この値を変更すると、サーバーで生成されるトリップが変更されます。
        constexpr const static char* TRIP_SHA_HMAC_KEY =
                "RfNmIE9QCk7CiNlbmDAodmRpZgojaWRU5TU0xf9pZZuZGVTk9fSURFQpjs==";

    private:
        unsigned char common_key_[COMMON_KEY_LENGTH];
        unsigned char common_key_iv_[COMMON_KEY_IV_LENGTH];

        EVP_CIPHER_CTX ctx_encrypt_,
                       ctx_decrypt_;
        RSA *rsa_key_;
};

}
