//
// ChatLog.hpp
//

#pragma once

#include <string>
#include <list>
#include <sqlite3.h>
#include <boost/thread.hpp>

typedef unsigned int UserID;
class SystemLog;

class ChatLog {
    public:
        struct Message {
                UserID user_id;
                std::string date;
                std::string body;
        };

    public:
        ChatLog(const std::string&);
        virtual ~ChatLog();

        void Push(Message);
        std::list<Message> Load();

    private:
        sqlite3 *db_;
        sqlite3_stmt *stmt_push_;

        std::list<Message> list_;
        boost::mutex mutex_;
};
