/*
 * Copyright (C) 2005-2011 Atsushi Konno All rights reserved.
 * Copyright (C) 2005 QSDN,Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#ifndef __CHXJ_COOKIE_H__
#define __CHXJ_COOKIE_H__

#include "mod_chxj.h"
#include "apr_file_io.h"
#include "apr_tables.h"
#include "apr_time.h"

#define CHXJ_COOKIE_PARAM               "_chxj_cc"
#define CHXJ_COOKIE_NOUPDATE_PARAM      "_chxj_nc"

#define DEFAULT_COOKIE_DB_DIR           "/tmp"
#define COOKIE_DB_NAME                  "cookie.db"
#define COOKIE_DB_LOCK_NAME             "cookie.db.lock"

#define COOKIE_EXPIRE_DB_NAME           "cookie.expire.db"
#define COOKIE_EXPIRE_DB_LOCK_NAME      "cookie.expire.db.lock"

#define REFERER_COOKIE_KEY              "CHXJ_REFER"
#define CHXJ_COOKIE_PROC_MUTEX_FILE     "/tmp/chxj_cookie_mutex.lock"

/* 
 * default cookie timeout is 30 minute
 */
#define DEFAULT_COOKIE_TIMEOUT          (1800)

extern apr_proc_mutex_t *global_cookie_mutex;


typedef struct cookie_t cookie_t;


struct cookie_t {
  char*               cookie_id;
  apr_array_header_t* cookie_headers;
};

typedef struct cookie_lock_t cookie_lock_t;

struct cookie_lock_t {
  apr_file_t *file;
};



extern cookie_t* chxj_save_cookie(
  request_rec*            r);

extern char* chxj_add_cookie_parameter(
  request_rec*            r, 
  char*                   value, 
  cookie_t*               cookie);

extern int chxj_cookie_check_host(
  request_rec*            r, 
  char*                   value);

extern cookie_t* chxj_load_cookie(
  request_rec*            r, 
  char*                   cookie_id);

extern apr_file_t* chxj_cookie_db_lock(
  request_rec*            r);

extern void chxj_cookie_db_unlock(
  request_rec*            r, 
  apr_file_t*             file);

extern void chxj_delete_cookie(request_rec *r, const char *cookie_id);

extern char* chxj_cookie_db_name_create(
  request_rec*            r, 
  const char*             dir);

extern char* chxj_cookie_db_lock_name_create(
  request_rec* r, 
  const char*  dir);

extern char* chxj_cookie_expire_db_lock_name_create(
  request_rec* r, 
  const char*  dir);

extern char* chxj_cookie_expire_db_name_create(
  request_rec* r, 
  const char*  dir);

extern apr_file_t* chxj_cookie_expire_db_lock(
  request_rec* r);

extern void chxj_cookie_expire_db_unlock(
  request_rec* r, 
  apr_file_t*  file);

extern void chxj_save_cookie_expire(
  request_rec* r, 
  cookie_t*    cookie);

extern void chxj_delete_cookie_expire(
  request_rec* r, 
  char*        cookie_id);

extern void chxj_cookie_expire_gc(
  request_rec* r);

extern cookie_t* chxj_update_cookie(
  request_rec* r, 
  cookie_t*    old_cookie);

extern apr_time_t chxj_parse_cookie_expires(const char *s);

extern cookie_lock_t *__chxj_cookie_lock(request_rec *r, const char *filename, int line);
extern int __chxj_cookie_unlock(request_rec *r, cookie_lock_t *lock, const char *filename, int line);

extern char *chxj_add_cookie_no_update_parameter(request_rec *r, char *value, int xmlflag);
extern char *chxj_cookie_only_mode(request_rec *r, const char *src, apr_size_t *len, cookie_t *cookie);
char * chxj_uniq_id(request_rec *r);

#define chxj_cookie_lock(X) __chxj_cookie_lock((X),__FILE__,__LINE__)
#define chxj_cookie_unlock(X,L) __chxj_cookie_unlock((X),(L),__FILE__,__LINE__)

#endif
/*
 * vim:ts=2 et
 */
