#include <jni.h>
#include <vector>
#include <string>
#include <algorithm>
#include <typeinfo>

namespace
{
	//! 連結後の文字列
	std::string message_;

	//! 文字列の連結
	void concat(const std::string& s)
	{
		message_ += s;
	}

	void cpptest()
	{
		using namespace std;

		// STLのテスト
		vector<string> v;
		v.push_back("今日も");
		v.push_back("Android");
		v.push_back("プログラミング");

		for_each(v.begin(), v.end(), concat);

		// 例外のテスト
		try
		{
			v.at(4) = "範囲外アクセス";
		}
		catch (...)
		{
			message_ += "例外発生!";
		}

		// RTTIのテスト
		const type_info& id = typeid(v);
		message_ += id.name();

	}

}	// namespace

extern "C"
{

	JNIEXPORT jstring JNICALL
	Java_com_test_Test_exec(JNIEnv* env, jobject)
	{
		cpptest();
		return env->NewStringUTF(message_.c_str());
	}

};
