/*
 * JNB2Money : Convert Japan Net Bank csv file to MS Money OFX file.
 *
 * Copyright (c) 2001, Takuya Murakami. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: MainForm.h 5 2003-04-05 12:25:21Z tmurakam $
 */
//---------------------------------------------------------------------------

#ifndef MainFormH
#define MainFormH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <Menus.hpp>
#include <Dialogs.hpp>
#include <Grids.hpp>
#include "Account.h"

//---------------------------------------------------------------------------
class TMForm : public TForm
{
__published:	// IDE Ǘ̃R|[lg
	TOpenDialog *OpenDialog;
	TButton *ButtonConvert;
	TButton *ButtonQuit;
	TButton *ButtonHelp;
	TStringGrid *AcGrid;
	TLabel *Label1;
	void __fastcall ButtonConvertClick(TObject *Sender);
	void __fastcall EditJNBAccountExit(TObject *Sender);
	void __fastcall ButtonQuitClick(TObject *Sender);
	void __fastcall FormShow(TObject *Sender);
	void __fastcall ButtonHelpClick(TObject *Sender);
	void __fastcall AcGridExit(TObject *Sender);
private:
	void SaveRegistry(void);
	void LoadRegistry(void);
	void Convert(AnsiString csvfile);	// [U[錾
public:		// [U[錾
	__fastcall TMForm(TComponent* Owner);
	Accounts accounts;
};
//---------------------------------------------------------------------------
extern PACKAGE TMForm *MForm;
//---------------------------------------------------------------------------
#endif
