/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.c.pre.directive;

public enum CpreIfState {

	TOP(true, false, false, true),
	BEGIN(true, false, false, false),
	READY(false, false, false, false),
	UNPROCESSED(false, false, false, false),
	PROCESSING(true, false, false, false),
	PROCESSED(false, true, false, false),
	PROCESSING_ELSE(true, false, true, false),
	DONE(false, true, true, false),
	RETURN(false, false, false, false),
	STAY(false, false, false, false);

	private boolean processing, processed, done, topLevel;

	CpreIfState(boolean p, boolean pd, boolean d, boolean t) {
		processing = p;
		processed = pd;
		done = d;
		topLevel = t;
	}

	/**
	 * 
	 * @return
	 */
	public boolean isProcessing() {
		return processing;
	}

	/**
	 * 
	 * @return
	 */
	public boolean isProcessed() {
		return processed;
	}

	/**
	 * 
	 * @return
	 */
	public boolean isDone() {
		return done;
	}

	/**
	 * 
	 * @return
	 */
	public boolean isTopLevel() {
		return topLevel;
	}

}
