/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.c.pre.expr;

import net.morilib.c.pre.CpreMacros;

public class CpreLiteralFloat extends CpreExpression
implements CpreValue {

	double value;

	public CpreLiteralFloat(double f) {
		value = f;
	}

	public double toFloat() {
		return value;
	}

	public long toLong() {
		return (long)value;
	}

	public int compareTo(CpreValue o) {
		double w = o.toFloat();

		return value < w ? -1 : value > w ? 1 : 0;
	}

	@Override
	public CpreValue eval(CpreMacros m) {
		return this;
	}

	public boolean isFloat() {
		return true;
	}

	public boolean isLong() {
		return false;
	}

	public boolean toBoolean() {
		return value != 0.0;
	}

}
