/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.c.pre.parser;

import java.math.BigInteger;

public class CpreIntegerToken extends CpreToken {

	private BigInteger value;

	public CpreIntegerToken(String x, int radix) {
		super(x);
		value = new BigInteger(x, radix);
	}

	public BigInteger getInteger() {
		return value;
	}

	public int hashCode() {
		return value.hashCode();
	}

	public boolean equals(Object o) {
		if(o instanceof CpreIntegerToken) {
			return value.equals(((CpreIntegerToken)o).value);
		}
		return false;
	}

}
