/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.c.pre;

public class CpreExpressionTest extends CpreTestCase {

	public void testDefined() {
		eqi("defined(__STDC__)", 1);
		eqi("defined(AAAA)", 0);
		eqi("defined(_0)", 0);
		eqi("defined(_A0)", 0);
		eqi("!defined(__STDC__)", 0);
	}

	public void testUnaries() {
		eqi("-1", -1);
		eqi("+1",  1);
		eqi("!0",  1);
		eqi("-1+2", 1);
		eqi("~1",  0xfffffffffffffffel);
	}

	public void testId() {
		eqi("1", 1);
		eqf("3.0", 3.0);
	}

	public void testFactor() {
		eqi("2*3", 6);
		eqi("2*3*4", 24);
		eqi("5%3", 2);
		eqi("4/2", 2);
		eqi("24/4/3", 2);
		eqi("24/4*3", 18);
		eqi("5%3%2", 0);
		eqf("2*3.0", 6.0);
		eqf("4/2.0", 2.0);
		eqi("2*\"3\"", 6);
		eqi("4/\"2\"", 2);
		eqi("5%\"3\"", 2);
		eqf("2*\"3.0\"", 6.0);
		eqf("4/\"2.0\"", 2.0);
		eqi("3/2", 1);
	}

	public void testTerm() {
		eqi("3+2", 5);
		eqi("3-2", 1);
		eqi("3-2-1", 0);
		eqi("3-2+1", 2);
		eqi("3*5+18/3", 21);
		eqf("3+2.0", 5.0);
		eqf("3-2.0", 1.0);
		eqi("3+\"2\"", 5);
		eqi("3-\"2\"", 1);
		eqf("3+\"2.0\"", 5.0);
		eqf("3-\"2.0\"", 1.0);
	}

	public void testRelop() {
		eqi("7 >  2", 1);
		eqi("7 >= 2", 1);
		eqi("7 <  2", 0);
		eqi("7 <= 2", 0);
		eqi("7 == 2", 0);
		eqi("7 != 2", 1);
		eqi("7 >  7", 0);
		eqi("7 >= 7", 1);
		eqi("7 <  7", 0);
		eqi("7 <= 7", 1);
		eqi("7 == 7", 1);
		eqi("7 != 7", 0);
		eqi("7 >  8", 0);
		eqi("7 >= 8", 0);
		eqi("7 <  8", 1);
		eqi("7 <= 8", 1);
		eqi("7 == 8", 0);
		eqi("7 != 8", 1);
		eqi("7 >  2.0", 1);
		eqi("7 >= 2.0", 1);
		eqi("7 <  2.0", 0);
		eqi("7 <= 2.0", 0);
		eqi("7 == 2.0", 0);
		eqi("7 != 2.0", 1);
		eqi("7 >  7.0", 0);
		eqi("7 >= 7.0", 1);
		eqi("7 <  7.0", 0);
		eqi("7 <= 7.0", 1);
		eqi("7 == 7.0", 1);
		eqi("7 != 7.0", 0);
		eqi("7 >  8.0", 0);
		eqi("7 >= 8.0", 0);
		eqi("7 <  8.0", 1);
		eqi("7 <= 8.0", 1);
		eqi("7 == 8.0", 0);
		eqi("7 != 8.0", 1);
		eqi("1+6 >  2", 1);
		eqi("1+6 >= 2", 1);
		eqi("1+6 <  2", 0);
		eqi("1+6 <= 2", 0);
		eqi("1+6 == 2", 0);
		eqi("1+6 != 2", 1);
	}

	public void testLogand() {
		eqi("1 && 1", 1);
		eqi("0 && 1", 0);
		eqi("1 && 0", 0);
		eqi("0 && 0", 0);
		eqi("2 + 0 && 1 + 3", 1);
		eqi("2 == 2 && 1 == 1", 1);
		eqi("2 != 2 && 1 == 1", 0);
		eqi("2 == 2 && 1 != 1", 0);
		eqi("2 != 2 && 1 != 1", 0);
		eqi("1 && 1 && 0", 0);
		eqi("1 && 1 && 1", 1);
	}

	public void testLogor() {
		eqi("1 || 1", 1);
		eqi("0 || 1", 1);
		eqi("1 || 0", 1);
		eqi("0 || 0", 0);
		eqi("2 + 0 || 1 + 3", 1);
		eqi("2 == 2 || 1 == 1", 1);
		eqi("2 != 2 || 1 == 1", 1);
		eqi("2 == 2 || 1 != 1", 1);
		eqi("2 != 2 || 1 != 1", 0);
		eqi("0 || 0 || 0", 0);
		eqi("1 || 0 || 0", 1);
		eqi("1 && 1 || 1 && 0", 1);
	}

	public void testCond() {
		eqi("1 ? 3 : 4", 3);
		eqi("0 ? 3 : 4", 4);
		eqi("1 ? 3 + 4 : 4 + 8", 7);
		eqi("0 ? 3 + 4 : 4 + 5", 9);
		eqi("1 ? 1 || 1 : 0 || 0", 1);
		eqi("0 ? 1 || 1 : 0 || 0", 0);
	}

	public void testBAnd() {
		eqi("3&5", 1);
		eqi("2&3&2", 2);
	}

	public void testBOr() {
		eqi("3|5", 7);
		eqi("2|3|2", 3);
		eqi("7&3^7&5|3&5", 7);
	}

	public void testBXor() {
		eqi("3^5", 6);
		eqi("2^3^2", 3);
	}

	public void testShift() {
		eqi("1<<5", 32);
		eqi("32>>5", 1);
	}

}
