/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.c.pre;

import java.io.IOException;
import java.io.StringReader;

public class CpreTest01 extends CpreTestCase {

	static void eot(String s, CPreprocessorReader r) {
		try {
			assertEquals(s, r.readLine());
		} catch (IOException e) {
			throw new RuntimeException(e);
		}
	}

	public void testCP0001() {
		StringReader f = new StringReader("" +
				"aaaaa\n" +
				"vvvvv\n");
		CPreprocessorReader r = new CPreprocessorReader(null, f);

		eot("aaaaa", r);
		eot("vvvvv", r);
	}

	public void testCP0002() {
		StringReader f = new StringReader("" +
				"__STDC__\n" +
				"vvvvv\n");
		CPreprocessorReader r = new CPreprocessorReader(null, f);

		eot("0", r);
		eot("vvvvv", r);
	}

	public void testCP0003() {
		StringReader f = new StringReader("" +
				"#define AAA 1\n" +
				"AAA\n");
		CPreprocessorReader r = new CPreprocessorReader(null, f);

		eot("", r);
		eot("1", r);
	}

	public void testCP0004() {
		StringReader f = new StringReader("" +
				"#define AAA(A) A\n" +
				"AAA(111)\n");
		CPreprocessorReader r = new CPreprocessorReader(null, f);

		eot("", r);
		eot("111", r);
	}

	public void testCP0005() {
		StringReader f = new StringReader("" +
				"#define AAA(A,B) A  B\n" +
				"AAA(111,222)\n");
		CPreprocessorReader r = new CPreprocessorReader(null, f);

		eot("", r);
		eot("111  222", r);
	}

	public void testCP0006() {
		StringReader f = new StringReader("" +
				"#define AAA(A, B) A  B\n" +
				"AAA(111, 222)\n");
		CPreprocessorReader r = new CPreprocessorReader(null, f);

		eot("", r);
		eot("111  222", r);
	}

	public void testCP0007() {
		StringReader f = new StringReader("" +
				"#define AAA( A , B ) A  B\n" +
				"AAA( 111 ,  222 )\n");
		CPreprocessorReader r = new CPreprocessorReader(null, f);

		eot("", r);
		eot("111  222", r);
	}

	public void testCP0008() {
		StringReader f = new StringReader("" +
				"#define AAA BBB\n" +
				"#define BBB 111\n" +
				"AAA\n");
		CPreprocessorReader r = new CPreprocessorReader(null, f);

		eot("", r);
		eot("", r);
		eot("111", r);
	}

	public void testCP0009() {
		StringReader f = new StringReader("" +
				"#define AAA(A) A\n" +
				"#define BBB 111\n" +
				"AAA(BBB)\n");
		CPreprocessorReader r = new CPreprocessorReader(null, f);

		eot("", r);
		eot("", r);
		eot("111", r);
	}

	public void testCP0010() {
		StringReader f = new StringReader("" +
				"#define AAA aaa\n" +
				"#ifdef AAA\n" +
				"111\n" +
				"222\n" +
				"#endif\n" +
				"333");
		CPreprocessorReader r = new CPreprocessorReader(null, f);

		eot("", r);
		eot("", r);
		eot("111", r);
		eot("222", r);
		eot("", r);
		eot("333", r);
	}

	public void testCP0011() {
		StringReader f = new StringReader("" +
				"#define AAA aaa\n" +
				"#ifdef BBB\n" +
				"111\n" +
				"222\n" +
				"#endif\n" +
				"333");
		CPreprocessorReader r = new CPreprocessorReader(null, f);

		eot("", r);
		eot("", r);
		eot("", r);
		eot("", r);
		eot("", r);
		eot("333", r);
	}

	public void testCP0012() {
		StringReader f = new StringReader("" +
				"#define AAA aaa\n" +
				"#if 1\n" +
				"111\n" +
				"222\n" +
				"#endif\n" +
				"333");
		CPreprocessorReader r = new CPreprocessorReader(null, f);

		eot("", r);
		eot("", r);
		eot("111", r);
		eot("222", r);
		eot("", r);
		eot("333", r);
	}

	public void testCP0013() {
		StringReader f = new StringReader("" +
				"#define AAA aaa\n" +
				"#if 0\n" +
				"111\n" +
				"222\n" +
				"#endif\n" +
				"333");
		CPreprocessorReader r = new CPreprocessorReader(null, f);

		eot("", r);
		eot("", r);
		eot("", r);
		eot("", r);
		eot("", r);
		eot("333", r);
	}

	public void testCP0014() {
		StringReader f = new StringReader("" +
				"AAA(B)");
		CPreprocessorReader r = new CPreprocessorReader(null, f);

		eot("AAA(B)", r);
	}

	public void testCP0015() {
		StringReader f = new StringReader("" +
				"#define AAA aaa\n" +
				"#if defined(AAA)\n" +
				"111\n" +
				"222\n" +
				"#endif\n" +
				"333");
		CPreprocessorReader r = new CPreprocessorReader(null, f);

		eot("", r);
		eot("", r);
		eot("111", r);
		eot("222", r);
		eot("", r);
		eot("333", r);
	}

	public void testCP0016() {
		StringReader f = new StringReader("" +
				"#define AAA aaa\n" +
				"#if defined(BBB)\n" +
				"111\n" +
				"222\n" +
				"#endif\n" +
				"333");
		CPreprocessorReader r = new CPreprocessorReader(null, f);

		eot("", r);
		eot("", r);
		eot("", r);
		eot("", r);
		eot("", r);
		eot("333", r);
	}

	public void testCP0017() {
		StringReader f = new StringReader("" +
				"#define AAA(A) aaa\n" +
				"#if defined(AAA)\n" +
				"111\n" +
				"222\n" +
				"#endif\n" +
				"333");
		CPreprocessorReader r = new CPreprocessorReader(null, f);

		eot("", r);
		eot("", r);
		eot("111", r);
		eot("222", r);
		eot("", r);
		eot("333", r);
	}

	public void testCP0018() {
		StringReader f = new StringReader("" +
				"#define AAA aaa\n" +
				"#ifndef AAA\n" +
				"111\n" +
				"222\n" +
				"#endif\n" +
				"333");
		CPreprocessorReader r = new CPreprocessorReader(null, f);

		eot("", r);
		eot("", r);
		eot("", r);
		eot("", r);
		eot("", r);
		eot("333", r);
	}

	public void testCP0019() {
		StringReader f = new StringReader("" +
				"#define AAA aaa\n" +
				"#ifndef BBB\n" +
				"111\n" +
				"222\n" +
				"#endif\n" +
				"333");
		CPreprocessorReader r = new CPreprocessorReader(null, f);

		eot("", r);
		eot("", r);
		eot("111", r);
		eot("222", r);
		eot("", r);
		eot("333", r);
	}

	public void testCP0020() {
		StringReader f = new StringReader("" +
				"#define AAA(A) aaa\n" +
				"#if !defined(AAA)\n" +
				"111\n" +
				"222\n" +
				"#endif\n" +
				"333");
		CPreprocessorReader r = new CPreprocessorReader(null, f);

		eot("", r);
		eot("", r);
		eot("", r);
		eot("", r);
		eot("", r);
		eot("333", r);
	}

	public void testCP0021() {
		StringReader f = new StringReader("" +
				"#define aaa(a) \"a\"\n" +
				"aaa(111)");
		CPreprocessorReader r = new CPreprocessorReader(null, f);

		eot("", r);
		eot("\"a\"", r);
	}

	public void testCP0022() {
		StringReader f = new StringReader("" +
				"#define aaa(a) #a\n" +
				"aaa(111)");
		CPreprocessorReader r = new CPreprocessorReader(null, f);

		eot("", r);
		eot("\"111\"", r);
	}

	public void testCP0023() {
		StringReader f = new StringReader("" +
				"#define aaa(a) # \n" +
				"aaa(111)");
		CPreprocessorReader r = new CPreprocessorReader(null, f);

		eot("", r);
		eot("# ", r);
	}

	public void testCP0024() {
		StringReader f = new StringReader("" +
				"#define aaa(a) #-\n" +
				"aaa(111)");
		CPreprocessorReader r = new CPreprocessorReader(null, f);

		eot("", r);
		eot("#-", r);
	}

	public void testCP0025() {
		StringReader f = new StringReader("" +
				"\"aaa\" \"bbb\"");
		CPreprocessorReader r = new CPreprocessorReader(null, f);

		eot("\"aaabbb\"", r);
	}

	public void testCP0026() {
		StringReader f = new StringReader("" +
				"\"aaa\"  \"bbb\"\"ccc\"");
		CPreprocessorReader r = new CPreprocessorReader(null, f);

		eot("\"aaabbbccc\"", r);
	}

	public void testCP0027() {
		StringReader f = new StringReader("" +
				"\"aaa\"  1  \"bbb\"2\"ccc\"");
		CPreprocessorReader r = new CPreprocessorReader(null, f);

		eot("\"aaa\"  1  \"bbb\"2\"ccc\"", r);
	}

	public void testCP0028() {
		StringReader f = new StringReader("" +
				"aaaa##bbb");
		CPreprocessorReader r = new CPreprocessorReader(null, f);

		eot("aaaabbb", r);
	}

	public void testCP0029() {
		StringReader f = new StringReader("" +
				"aaaa  ##   bbb");
		CPreprocessorReader r = new CPreprocessorReader(null, f);

		eot("aaaabbb", r);
	}

	public void testCP0030() {
		StringReader f = new StringReader("" +
				"#define aaa(b, c) b##c\n" +
				"aaa(abc, 123)");
		CPreprocessorReader r = new CPreprocessorReader(null, f);

		eot("", r);
		eot("abc123", r);
	}

	public void testCP0031() {
		StringReader f = new StringReader("" +
				"#define aaa(b, c) b#\"aa\"\n" +
				"aaa(abc, 123)");
		CPreprocessorReader r = new CPreprocessorReader(null, f);

		eot("", r);
		eot("abc#\"aa\"", r);
	}

	public void testCP0032() {
		StringReader f = new StringReader("" +
				"aaaa#\"bbb\"");
		CPreprocessorReader r = new CPreprocessorReader(null, f);

		eot("aaaa#\"bbb\"", r);
	}

	public void testCP0033() {
		StringReader f = new StringReader("" +
				"#define PREFIX \"main-\"\n" +
				"#define SUFFIX \".c\"\n" +
				"#define fname(name) PREFIX #name SUFFIX\n" +
				"p = fname(func);\n");
		CPreprocessorReader r = new CPreprocessorReader(null, f);

		eot("", r);
		eot("", r);
		eot("", r);
		eot("p = \"main-func.c\";", r);
	}

	public void testCP0034() {
		StringReader f = new StringReader("" +
				"#define AAA aaa\n" +
				"#if 0\n" +
				"111\n" +
				"#else\n" +
				"222\n" +
				"#endif\n" +
				"333");
		CPreprocessorReader r = new CPreprocessorReader(null, f);

		eot("", r);
		eot("", r);
		eot("", r);
		eot("", r);
		eot("222", r);
		eot("", r);
		eot("333", r);
	}

	public void testCP0035() {
		StringReader f = new StringReader("" +
				"#define AAA aaa\n" +
				"#if 1\n" +
				"111\n" +
				"#else\n" +
				"222\n" +
				"#endif\n" +
				"333");
		CPreprocessorReader r = new CPreprocessorReader(null, f);

		eot("", r);
		eot("", r);
		eot("111", r);
		eot("", r);
		eot("", r);
		eot("", r);
		eot("333", r);
	}

	public void testCP0036() {
		StringReader f = new StringReader("" +
				"#define AAA aaa\n" +
				"#if 1\n" +
				"111\n" +
				"#elif 1\n" +
				"222\n" +
				"#else\n" +
				"444\n" +
				"#endif\n" +
				"333");
		CPreprocessorReader r = new CPreprocessorReader(null, f);

		eot("", r);
		eot("", r);
		eot("111", r);
		eot("", r);
		eot("", r);
		eot("", r);
		eot("", r);
		eot("", r);
		eot("333", r);
	}

	public void testCP0037() {
		StringReader f = new StringReader("" +
				"#define AAA aaa\n" +
				"#if 0\n" +
				"111\n" +
				"#elif 1\n" +
				"222\n" +
				"#else\n" +
				"444\n" +
				"#endif\n" +
				"333");
		CPreprocessorReader r = new CPreprocessorReader(null, f);

		eot("", r);
		eot("", r);
		eot("", r);
		eot("", r);
		eot("222", r);
		eot("", r);
		eot("", r);
		eot("", r);
		eot("333", r);
	}

	public void testCP0038() {
		StringReader f = new StringReader("" +
				"#define AAA aaa\n" +
				"#if 0\n" +
				"111\n" +
				"#elif 0\n" +
				"222\n" +
				"#else\n" +
				"444\n" +
				"#endif\n" +
				"333");
		CPreprocessorReader r = new CPreprocessorReader(null, f);

		eot("", r);
		eot("", r);
		eot("", r);
		eot("", r);
		eot("", r);
		eot("", r);
		eot("444", r);
		eot("", r);
		eot("333", r);
	}

	public void testCP0039() {
		StringReader f = new StringReader("" +
				"#define AAA aaa\n" +
				"#if 1\n" +
				"#if 1\n" +
				"111\n" +
				"222\n" +
				"#endif\n" +
				"444\n" +
				"#endif\n" +
				"333");
		CPreprocessorReader r = new CPreprocessorReader(null, f);

		eot("", r);
		eot("", r);
		eot("", r);
		eot("111", r);
		eot("222", r);
		eot("", r);
		eot("444", r);
		eot("", r);
		eot("333", r);
	}

	public void testCP0040() {
		StringReader f = new StringReader("" +
				"#define AAA aaa\n" +
				"#if 1\n" +
				"#if 0\n" +
				"111\n" +
				"222\n" +
				"#endif\n" +
				"444\n" +
				"#endif\n" +
				"333");
		CPreprocessorReader r = new CPreprocessorReader(null, f);

		eot("", r);
		eot("", r);
		eot("", r);
		eot("", r);
		eot("", r);
		eot("", r);
		eot("444", r);
		eot("", r);
		eot("333", r);
	}

}
