/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.c.pre;

import java.io.IOException;
import java.io.StringReader;

public class CpreTest02 extends CpreTestCase {

	static void eot(String s, CPreprocessorReader r) {
		try {
			assertEquals(s, r.readLine());
		} catch (IOException e) {
			throw new RuntimeException(e);
		}
	}

	public void testCP0101() {
		StringReader f = new StringReader("" +
				"#include \"test01.h\"\n" +
				"end\n");
		CPreprocessorReader r = new CPreprocessorReader(null, f);

		eot("aaaaa", r);
		eot("vvvvv", r);
		eot("end", r);
	}

}
