/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.c.pre;

import java.io.IOException;
import java.io.StringReader;

public class CpreTest03 extends CpreTestCase {

	static void eot(String s, CPreprocessorReader r) {
		try {
			assertEquals(s, r.readLine());
		} catch (IOException e) {
			throw new RuntimeException(e);
		}
	}

	static void err(CPreprocessorReader r) {
		try {
			r.readLine();  fail();
		} catch(CpreException e) {
			// ok
		} catch(IOException e) {
			throw new RuntimeException(e);
		}
	}

	public void testCP9001() {
		StringReader f = new StringReader("" +
				"#endif");
		CPreprocessorReader r = new CPreprocessorReader(null, f);

		err(r);
	}

	public void testCP9002() {
		StringReader f = new StringReader("" +
				"#else");
		CPreprocessorReader r = new CPreprocessorReader(null, f);

		err(r);
	}

	public void testCP9003() {
		StringReader f = new StringReader("" +
				"#elif 1");
		CPreprocessorReader r = new CPreprocessorReader(null, f);

		err(r);
	}

	public void testCP9004() {
		StringReader f = new StringReader("" +
				"#if 1");
		CPreprocessorReader r = new CPreprocessorReader(null, f);

		eot("", r);
		err(r);
	}

	public void testCP9005() {
		StringReader f = new StringReader("" +
				"#if 1\n" +
				"#else\n" +
				"#else");
		CPreprocessorReader r = new CPreprocessorReader(null, f);

		eot("", r);
		eot("", r);
		err(r);
	}

	public void testCP9006() {
		StringReader f = new StringReader("" +
				"#if 1\n" +
				"#else\n" +
				"#elif 1");
		CPreprocessorReader r = new CPreprocessorReader(null, f);

		eot("", r);
		eot("", r);
		err(r);
	}

}
