/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.c.pre;

import java.io.IOException;
import java.io.StringReader;

import net.morilib.c.pre.parser.CpreLexer;
import net.morilib.c.pre.parser.CpreParser;
import junit.framework.TestCase;

public class CpreTestCase extends TestCase {

	CpreMacros m;

	public void setUp() {
		m = new CpreMacros();
		m.define("__STDC__", "0");
	}

	static CpreLexer lex(String s) {
		try {
			return new CpreLexer(1, new StringReader(s));
		} catch (IOException e) {
			throw new RuntimeException(s);
		}
	}

	void eqi(String l, long s) {
		try {
			assertEquals(CpreParser.parseExpression(lex(l)).eval(1, m).toLong(), s);
		} catch (IOException e) {
			throw new RuntimeException(e);
		}
	}

	void eqb(String l, boolean b) {
		try {
			assertEquals(CpreParser.parseExpression(lex(l)).eval(1, m).toBoolean(), b);
		} catch (IOException e) {
			throw new RuntimeException(e);
		}
	}

	void eqf(String l, double s) {
		try {
			assertEquals(CpreParser.parseExpression(lex(l)).eval(1, m).toFloat(), s);
		} catch (IOException e) {
			throw new RuntimeException(e);
		}
	}

	void err(String l) {
		try {
			CpreParser.parseExpression(lex(l));  fail();
		} catch(CpreException e) {
			// ignore
		} catch (IOException e) {
			throw new RuntimeException(e);
		}
	}

}
