/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.config;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.core.config.BeanConfig;
import org.apache.jackrabbit.core.config.ConfigurationException;
import org.apache.jackrabbit.core.security.user.action.AuthorizableAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserManagerConfig
extends BeanConfig {
    private static final Logger log = LoggerFactory.getLogger(UserManagerConfig.class);
    private Constructor<?> constr;
    private final BeanConfig[] actionConfig;

    public UserManagerConfig(BeanConfig config) {
        this(config, null);
    }

    public UserManagerConfig(BeanConfig config, BeanConfig[] actionConfig) {
        super(config);
        this.setValidate(false);
        this.actionConfig = actionConfig;
    }

    public UserManager getUserManager(Class<? extends UserManager> assignableFrom, Class<?>[] parameterTypes, Object ... initArgs) throws ConfigurationException {
        if (this.constr == null) {
            String msg = "Invalid UserManager implementation '" + this.getClassName() + "'.";
            try {
                Class<?> umgrCl = Class.forName(this.getClassName(), true, this.getClassLoader());
                if (!assignableFrom.isAssignableFrom(umgrCl)) {
                    throw new ConfigurationException("Configured UserManager '" + this.getClassName() + "' is not assignable from " + assignableFrom);
                }
                this.constr = umgrCl.getConstructor(parameterTypes);
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationException(msg, (Exception)e);
            }
            catch (NoSuchMethodException e) {
                throw new ConfigurationException(msg, (Exception)e);
            }
        }
        try {
            return (UserManager)this.constr.newInstance(initArgs);
        }
        catch (Exception e) {
            throw new ConfigurationException("Invalid UserManager implementation '" + this.getClassName() + "'.", e);
        }
    }

    public AuthorizableAction[] getAuthorizableActions() throws ConfigurationException {
        if (this.actionConfig == null || this.actionConfig.length == 0) {
            return new AuthorizableAction[0];
        }
        ArrayList<AuthorizableAction> actions = new ArrayList<AuthorizableAction>(this.actionConfig.length);
        for (BeanConfig c : this.actionConfig) {
            AuthorizableAction action = c.newInstance(AuthorizableAction.class);
            actions.add(action);
        }
        return actions.toArray(new AuthorizableAction[actions.size()]);
    }
}

