/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import org.apache.jackrabbit.core.query.lucene.AbstractIndex;
import org.apache.jackrabbit.core.query.lucene.DocNumberCache;
import org.apache.jackrabbit.core.query.lucene.IndexDeletionPolicyImpl;
import org.apache.jackrabbit.core.query.lucene.IndexListener;
import org.apache.jackrabbit.core.query.lucene.IndexMigration;
import org.apache.jackrabbit.core.query.lucene.IndexingQueue;
import org.apache.jackrabbit.core.query.lucene.ReadOnlyIndexReader;
import org.apache.jackrabbit.core.query.lucene.directory.DirectoryManager;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;

class PersistentIndex
extends AbstractIndex {
    private final String name;
    private IndexListener listener;
    private final IndexDeletionPolicyImpl indexDelPolicy;
    private long generation;

    PersistentIndex(String name, Analyzer analyzer, Similarity similarity, DocNumberCache cache, IndexingQueue indexingQueue, DirectoryManager directoryManager, long generationMaxAge) throws IOException {
        super(analyzer, similarity, directoryManager.getDirectory(name), cache, indexingQueue);
        this.name = name;
        this.indexDelPolicy = new IndexDeletionPolicyImpl(this, generationMaxAge * 1000L);
        if (this.isExisting()) {
            IndexMigration.migrate(this, directoryManager, '\uffff');
        }
    }

    @Override
    int removeDocument(Term idTerm) throws IOException {
        int num = super.removeDocument(idTerm);
        if (num > 0 && this.listener != null) {
            this.listener.documentDeleted(idTerm);
        }
        return num;
    }

    @Override
    protected IndexDeletionPolicy getIndexDeletionPolicy() {
        return this.indexDelPolicy;
    }

    void addIndexes(IndexReader[] readers) throws IOException {
        this.getIndexWriter().addIndexes(readers);
        this.getIndexWriter().optimize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void copyIndex(AbstractIndex index) throws IOException {
        String[] files;
        index.commit(true);
        byte[] buffer = new byte[1024];
        Directory dir = index.getDirectory();
        Directory dest = this.getDirectory();
        for (String file : files = dir.listAll()) {
            try (IndexInput in = dir.openInput(file);
                 IndexOutput out = dest.createOutput(file);){
                int num;
                for (long remaining = in.length(); remaining > 0L; remaining -= (long)num) {
                    num = (int)Math.min(remaining, (long)buffer.length);
                    in.readBytes(buffer, 0, num);
                    out.writeBytes(buffer, num);
                }
            }
        }
        this.indexDelPolicy.readCurrentGeneration();
    }

    synchronized ReadOnlyIndexReader getReadOnlyIndexReader(IndexListener listener) throws IOException {
        ReadOnlyIndexReader reader = this.getReadOnlyIndexReader();
        this.listener = listener;
        return reader;
    }

    synchronized void resetListener() {
        this.listener = null;
    }

    int getNumDocuments() throws IOException {
        return this.getIndexReader().numDocs();
    }

    String getName() {
        return this.name;
    }

    long getCurrentGeneration() {
        return this.generation;
    }

    void setCurrentGeneration(long generation) {
        this.generation = generation;
    }
}

