/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.sql.ParameterMetaData;
import java.sql.SQLException;
import org.apache.derby.iapi.sql.ParameterValueSet;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataTypeUtilities;
import org.apache.derby.impl.jdbc.Util;

public class EmbedParameterSetMetaData
implements ParameterMetaData {
    private final ParameterValueSet pvs;
    private final DataTypeDescriptor[] types;
    private final int paramCount;

    protected EmbedParameterSetMetaData(ParameterValueSet parameterValueSet, DataTypeDescriptor[] dataTypeDescriptorArray) {
        int n = parameterValueSet.getParameterCount();
        this.pvs = parameterValueSet;
        this.paramCount = n;
        this.types = dataTypeDescriptorArray;
    }

    @Override
    public int getParameterCount() {
        return this.paramCount;
    }

    @Override
    public int isNullable(int n) throws SQLException {
        this.checkPosition(n);
        if (this.types[n - 1].isNullable()) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean isSigned(int n) throws SQLException {
        this.checkPosition(n);
        return this.types[n - 1].getTypeId().isNumericTypeId();
    }

    @Override
    public int getPrecision(int n) throws SQLException {
        this.checkPosition(n);
        int n2 = -1;
        if (n == 1 && this.pvs.hasReturnOutputParameter()) {
            n2 = this.pvs.getPrecision(n);
        }
        if (n2 == -1) {
            return DataTypeUtilities.getPrecision(this.types[n - 1]);
        }
        return n2;
    }

    @Override
    public int getScale(int n) throws SQLException {
        this.checkPosition(n);
        if (n == 1 && this.pvs.hasReturnOutputParameter()) {
            return this.pvs.getScale(n);
        }
        return this.types[n - 1].getScale();
    }

    @Override
    public int getParameterType(int n) throws SQLException {
        this.checkPosition(n);
        return this.types[n - 1].getTypeId().getJDBCTypeId();
    }

    @Override
    public String getParameterTypeName(int n) throws SQLException {
        this.checkPosition(n);
        return this.types[n - 1].getTypeId().getSQLTypeName();
    }

    @Override
    public String getParameterClassName(int n) throws SQLException {
        this.checkPosition(n);
        return this.types[n - 1].getTypeId().getResultSetMetaDataTypeName();
    }

    @Override
    public int getParameterMode(int n) throws SQLException {
        this.checkPosition(n);
        if (n == 1 && this.pvs.hasReturnOutputParameter()) {
            return 4;
        }
        return this.pvs.getParameterMode(n);
    }

    private void checkPosition(int n) throws SQLException {
        if (n < 1 || n > this.paramCount) {
            throw Util.generateCsSQLException("XCL13.S", new Integer(n), new Integer(this.paramCount));
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        try {
            return clazz.cast(this);
        }
        catch (ClassCastException classCastException) {
            throw Util.generateCsSQLException("XJ128.S", clazz);
        }
    }
}

