package com.wiki.standalone.moxkiriya.parser.blockparser;

import com.wiki.standalone.moxkiriya.WikiEngine;

public class WikiHrBlockParser extends WikiBlockParserBase {
	private static final String START_TAG = "<hr>";

	private static final String END_TAG = "";
	
	/** WIKI記法の正規表現文字列　行頭パターン */
	private static final String NOTATION_REGEX_LINEHEAD = "^----";

	/** WIKI記法の正規表現文字列　行末パターン */
	private static final String NOTATION_REGEX_LINETAIL = "$";
	
	/** WIKI記法の正規表現文字列 */
	public static final String NOTATION_REGEX = NOTATION_REGEX_LINEHEAD
			+ NOTATION_REGEX_LINETAIL;

	/** 
	 *　 コンストラクタ
	 */
	public WikiHrBlockParser(WikiEngine wikiEngine) {
		super(wikiEngine);
	}

	@Override
	public String startElementProcess(String line, StringBuffer buf) {
		buf.append(START_TAG);
		return line.replaceFirst(NOTATION_REGEX_LINEHEAD, "");
	}

	@Override
	public String endElementProcess(String line, StringBuffer buf) {
		buf.append(END_TAG);
		return "";
	}

	@Override
	public boolean isBlockEnd() {
		return true;
	}
}
