/**
 * Moxkiriya standalone Wiki.
 * Ordered list block parser.
 * 
 * @author Ryuhei Terada
 * See the '<a href="{@docRoot}/copyright.html">Copyright</a>'
 */
package com.wiki.standalone.moxkiriya.parser.blockparser;

import com.wiki.standalone.moxkiriya.WikiEngine;

/**
 * 番号付きリストのマークアップを解析し、HTML形式に変換する。
 *
 */
public class WikiOrderedListBlockParser extends WikiBlockParserBase {
	private static final String START_TAG = "<div><ol>\n";

	private static final String END_TAG = "</ol></div>\n";
	
	/** WIKI記法の正規表現文字列　行頭パターン */
	private static final String NOTATION_REGEX_LINEHEAD = "^[ \t]*"
															+ "#+"
															+ " +[^#]";

	/** WIKI記法の正規表現文字列　行末パターン */
	private static final String NOTATION_REGEX_LINETAIL = "";
	
	/** WIKI記法の正規表現文字列 */
	public static final String NOTATION_REGEX = NOTATION_REGEX_LINEHEAD
			+ "..*"
			+ NOTATION_REGEX_LINETAIL;

	/**	ブロック終了状態 */
	private boolean isBlockEnd_ = false;

	/** 処理終了後の残り文字列 */
	private String  remain_;
	
	/** 
	 *　 コンストラクタ
	 */
	public WikiOrderedListBlockParser(WikiEngine wikiEngine) {
		this(wikiEngine, Status.INIT);
	}

	/** 
	 *　 コンストラクタ
	 */
	public WikiOrderedListBlockParser(WikiEngine wikiEngine, Status status) {
		super(wikiEngine);
		status_ = status;
	}
	
	@Override
	public String startElementProcess(String line, StringBuffer buf) {
		status_ = Status.OPEN;
		buf.append(START_TAG);
		return line;
	}

	@Override
	public String parse(String line, StringBuffer buf) throws Exception {
		if(line.matches(NOTATION_REGEX) == true) {
			String token      = line.substring(line.indexOf("#"));
			int    countToken = countToken(token, '#');
			if(countToken > 1) {
				/*
				 * '#'を一つ減らして子parserへ渡す。
				 */
				String daughterPart = token.substring(1);
				
				if(status_ == Status.OPEN) {
					startDaughterParse(new WikiBlockParserCreator.Creator() {
						@Override
						public WikiOrderedListBlockParser create(WikiEngine wikiEngine) {
							return new WikiOrderedListBlockParser(wikiEngine, Status.OPEN);
						}
					});
					
					daughterParser_.startElementProcess(daughterPart, buf);
				}
				daughterParser_.parse(daughterPart, buf);
			}
			else {
				if(status_ == Status.NESTING) {
					/*
					 * トークンが1つでネスト処理中の場合、
					 * ネスト処理を終了する。
					 */
					daughterParser_.endElementProcess(line, buf);
					daughterParser_ = null;
					status_ = Status.OPEN;
				}
				super.parse(line, buf);
				remain_ = "";				
			}
		}
		else {
			isBlockEnd_ = true;
			remain_     = line;
		}

		return "";
	}

	@Override
	public String endElementProcess(String line, StringBuffer buf) {
		if(status_ == Status.NESTING) {
			daughterParser_.endElementProcess(line, buf);
		}
		buf.append(END_TAG + "\n");
		return remain_;
	}

	@Override
	public boolean isBlockEnd() {
		return isBlockEnd_;
	}
}
