///*********************************************************/
///*!
// @addtoGroup AB3D
// @file proxyDBClass.h
// @brief AB3D Peak Position Main DB Ctrl
// 
// @date 2013.07.01
// @author M.Fukuda
// @varsion 1.0.0
//
// -------------------------------------------------------
// Copyright(C) 2006-2014
// Eisai Co., Ltd. All rights reserved.
// -------------------------------------------------------
// @note
//    Mass++EMSDB̎قȂ邽߁A
//	proxyŃCX^X킹ĂA
//	pMass++EMSŐ؂ւĐ킹B
// */
///*********************************************************/
//#pragma once
//
//// O錾
//namespace AB3D {
//	class DbAccess;
//	struct TmpMXVal;
//	struct ElmPoint;
//}
//
//namespace AB3D {
//
///*!--------------------------------------------------------
//    @name   DbProxyClass
//    @brief  Data Base Proxy Class
//    @date   2013.07.01
//    @par    قȂɑΉ邽߂̋ʃC^[tF[X̃NX
//
//	LɂČpɖ{̂Kv
//		+ onInitMe
//		+ onCommitMe
//		+ onCloseActiveSample
//		+ onOpenTargtIdSample
//		+ onGetMatrixId
//		+ onGetSampleIds
//		+ onSetXYBuffer
//		+ onSetPeak
//		+ onSetValues
//
//-----------------------------------------------------------*/
//	class DbProxyClass {
//	
//	public:
//		// constructor
//		DbProxyClass();
//		// destructor
//		~DbProxyClass();
//
//	private:
//		// Uncopyable
//		DbProxyClass(const DbProxyClass&);
//		DbProxyClass& operator=(const DbProxyClass&);
//
//	protected:
//		// DB Accesser 쐬ĕێ
//		std::unique_ptr<DbAccess> ptr_;
//		// ݍ쐬Matrix IDێ
//		int matrixID_;
//
//		kome::ident::PeakPositions* peakpos_;
//
//	public:
//		/*!
//		 * @brief  g̏s
//		 * @retval s False 
//		 * @note   onInitMeIɌĂ
//		 */
//		const bool initMe();
//
//		/*!
//		 * @brief  DBgpł邩`FbN
//		 * @param[out]  ANeBuMatrixID
//		 * @param[out]  ̗ނTvIDQ
//		 * @retval s False 
//		 * @note + onGetMatrixId
//		         + onGetSampleIds
//		 */
//		const bool isReadyDB(
//			int& refMatrixId,
//			std::vector<int>& refSampleIds);
//
//		/*!
//		 * @brief  wID̃Tvf[^擾
//		 * @param[in]   TvID
//		 * @param[out]  TvDataSet
//		 * @retval s False 
//		 * @note   + onOpenTargtIdSample
//		 */
//		const bool openTargtIdSample(
//			const int sampleId,
//			kome::objects::DataSet& refDataSet);
//
//		/*!
//		 * @brief  DBŊJANeBuTv
//		 * @note   + onCloseActiveSample
//		 */
//		void closeActiveSample();
//
//		/*!
//		 * @brief  Buffere[uɏ
//		 * @param[in] Buffer
//		 * @retval    BufferIDBs -1
//		 * @note   + onSetXYBuffer
//		 */
//		const int setXYBuffer(
//			kome::core::Buffer* buffer);
//
//		/*!
//		 * @brief  Peake[uɏ
//		 * @param[in] MatrixID
//		 * @param[in] M/Z
//		 * @param[in] Retention time(Min)
//		 * @param[in] Charge
//		 * @param[in] Value
//		 * @retval    PeakIDBs -1
//		 * @note   + onSetPeak
//		 */
//		const int setPeak(
//			const int mtId,
//			const double mz,
//			const double rt,
//			const int charge
//			);
//
//		/*!
//		 * @brief  Peak̏ڍׂe[uɏ
//		 * @param[in] PeakID
//		 * @param[in] SampleID
//		 * @param[in] BufferID
//		 * @param[in] Peak̏ڍ׏\
//		 * @retval    s False
//		 * @note   + onSetValues
//		 */
//		const bool setValues(
//			const int peakId,
//			const int sampleId,
//			const int bufId,
//			AB3D::TmpMXVal& tmval);
//		
//		/*!
//		 * @brief  I
//		 */
//		void closeMe();
//
//		/*!
//		 * @brief R~bg
//		 * @note + onCommitMe
//		 */
//		void commitMe();
//
//	protected:
//		// ȍ~ACX^X͋ʂĂ邪A
//		// g͌ʂɏقǂB
//
//		/*!
//		 * @brief  g̏s
//		 * @retval s False 
//		 */
//		virtual const bool onInitMe();
//
//		/*!
//		 * @brief  wID̃Tvf[^擾̎
//		 * @param[in]   TvID
//		 * @param[out]  TvDataSet
//		 * @retval s False 
//		 */
//		virtual const bool onOpenTargtIdSample(
//			const int sampleId,
//			kome::objects::DataSet& refDataSet) = 0;
//
//		/*!
//		 * @brief  DBŊJANeBuTv
//		 */
//		virtual void onCloseActiveSample() = 0;
//
//		/*!
//		 * @brief  ANeBuMatrixID擾
//		 * @param[out]  MatrixID
//		 * @retval s False 
//		 */
//		virtual const bool onGetMatrixId(
//			int& refMatrixId) = 0;
//
//		/*!
//		 * @brief  wMatrixID̃TvIDQ擾
//		 * @param[in]   MatrixID
//		 * @param[out]  TvIDQ
//		 * @retval s False 
//		 */
//		virtual const bool onGetSampleIds(
//			const int matrixId,
//			std::vector<int>& refSampleIds) = 0;
//
//		/*!
//		 * @brief  Buffere[uɏ
//		 * @param[in] Buffer
//		 * @retval    BufferIDBs -1
//		 */
//		virtual const int onSetXYBuffer(
//			kome::core::Buffer* buffer) = 0;
//
//		/*!
//		 * @brief  Peake[uɏ
//		 * @param[in] MatrixID
//		 * @param[in] M/Z
//		 * @param[in] Retention time(Min)
//		 * @param[in] Charge
//		 * @retval    PeakIDBs -1
//		 */
//		virtual const int onSetPeak(
//			const int mtId,
//			const double mz,
//			const double rt,
//			const int charge
//			) = 0;
//
//		/*!
//		 * @brief  Peak̏ڍׂe[uɏ
//		 * @param[in] PeakID
//		 * @param[in] SampleID
//		 * @param[in] BufferID
//		 * @param[in] Peak̏ڍ׏\
//		 * @retval    s False
//		 */
//		virtual const bool onSetValues(
//			const int peakId,
//			const int sampleId,
//			const int bufId,
//			AB3D::TmpMXVal& tmval) = 0;
//
//		/*!
//		 * @brief R~bg
//		 */
//		virtual void onCommitMe() = 0;
//	};
//}
//
//
