/*********************************************************/
/*!
 @addtoGroup AB3D
 @file progressAdpt.cpp
 @brief progress adapter
 
 @date 2013.07.01
 @author M.Fukuda
 @varsion 1.0.0

 -------------------------------------------------------
 Copyright(C) 2006-2014
 Eisai Co., Ltd. All rights reserved.
 -------------------------------------------------------
 @note
    vOX𐧌䂷Õx[XłB
 */
/*********************************************************/
#include "../stdafx.h"
#include "ProgressAdapter.h"

// memo
// progressɂ

// progresś@setRangeŔ͈͂߂āA
// setPositionňʒu𓮂A
// vOẌׂ̃JEgpӂA
// setStatusŃbZ[WςKvL܂B
// 葱ώGŁAR[h̉ǐ܂B
// Ȃ̂ŁANXƂĂ܂Ƃ߂Ă܂B

// constructor
ProgressAdapter::ProgressAdapter(
	kome::core::Progress* _progress,
	const int lastCount
	) : progress_(_progress)
	, firstCount_(0)
	, lastCount_(lastCount)
{
//	initMe();
}

// constrctor
ProgressAdapter::ProgressAdapter(
	kome::core::Progress* _progress,
	const int firstCount,
	const int lastCount
	) : progress_(_progress)
	, firstCount_(firstCount)
	, lastCount_(lastCount)
{
//	initMe();
}

// BpNXŌĂяoB
void ProgressAdapter::initMe()
{
	if (progress_ != nullptr) {
		onInitMe();
	}
}

// initŌĂяoB
void ProgressAdapter::onInitMe() 
{
	onShowStatus("");
}

// Œ胁bZ[WŃvOXi߂鎞͂Ă
const bool ProgressAdapter::nextStep()
{
	if(progress_ == nullptr) {
		return false;
	}

	nowCount_++;
	if (lastCount_ < nowCount_) {
		return false;
	}
	progress_->setPosition(nowCount_);
	return onNextStep();
}

// vOXi߂B
// bZ[WύXƂ͂g
const bool ProgressAdapter::nextStep(
	const std::string& msg
){
	if(progress_ == nullptr) {
		return false;
	}

	nowCount_++;

	if (lastCount_ < nowCount_) {
		return false;
	}
	
	progress_->setPosition(nowCount_);
	onShowStatus(msg);
	return true;
}


const bool ProgressAdapter::onNextStep()
{
	// is󋵂\bZ[W
	onShowStatus("");
	return true;
}

// progress N[Y
void ProgressAdapter::closeMe()
{
	if (progress_ != nullptr) {
		onCloseMe();
		progress_->fill();
	}
}

void ProgressAdapter::onCloseMe()
{
	// ĨbZ[W
	onShowStatus("");
}

void ProgressAdapter::onShowStatus(const std::string& msg)
{
	if (progress_ != nullptr) {
		progress_->setStatus(msg.c_str());
	}
}
